/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Stringer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class ByteString {
    private final byte[] data;
    private transient int hashCode;
    public static final ByteString EMPTY = ByteString.of(new byte[0]);

    public static ByteString of(byte ... data) {
        return new ByteString((byte[])data.clone());
    }

    public static ByteString of(byte[] data, int offset, int count) {
        byte[] bytes = new byte[count];
        System.arraycopy(data, offset, bytes, 0, count);
        return new ByteString(bytes);
    }

    public static ByteString of(String data) {
        return new ByteString(Stringer.decode(data));
    }

    public static ByteString read(InputStream in, int count) throws IOException {
        int read;
        byte[] result = new byte[count];
        for (int c = 0; c < count; c += read) {
            read = in.read(result, c, count - c);
            if (read != -1) continue;
            throw new EOFException("Expected " + count + "; received " + c);
        }
        return new ByteString(result);
    }

    private ByteString(byte[] data) {
        this.data = data;
    }

    public byte byteAt(int index) {
        return this.data[index];
    }

    public int size() {
        return this.data.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.data.clone();
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.data);
    }

    public void write(OutputStream out, int offset, int count) throws IOException {
        out.write(this.data, offset, count);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ByteString && Arrays.equals(((ByteString)o).data, this.data);
    }

    public int hashCode() {
        int result = this.hashCode;
        return result != 0 ? result : (this.hashCode = Arrays.hashCode(this.data));
    }

    public String toString() {
        return Stringer.encode(this.data);
    }
}

