/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.WireType;
import java.io.IOException;

public final class WireOutput {
    private final byte[] buffer;
    private final int limit;
    private int position;

    public static int int32Size(int value) {
        if (value >= 0) {
            return WireOutput.varint32Size(value);
        }
        return 10;
    }

    public static int int64Size(long value) {
        if (value >= 0L) {
            return WireOutput.varint64Size(value);
        }
        return 10;
    }

    public static int tagSize(int fieldNumber, WireType wireType) {
        return WireOutput.int32Size(WireOutput.makeTag(fieldNumber, wireType));
    }

    public static int messageSize(int fieldNumber, int messageLength) {
        return WireOutput.tagSize(fieldNumber, WireType.LENGTH_DELIMITED) + WireOutput.int32Size(messageLength) + messageLength;
    }

    public static int writeTag(int fieldNumber, WireType wireType, byte[] buffer, int offset) {
        return WireOutput.writeVarint(WireOutput.makeTag(fieldNumber, wireType), buffer, offset);
    }

    public static int writeVarint(long value, byte[] buffer, int offset) {
        int start = offset;
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buffer[offset++] = (byte)value;
                return offset - start;
            }
            buffer[offset++] = (byte)(value & 0x7FL | 0x80L);
            value >>>= 7;
        }
    }

    public static int messageHeaderSize(int fieldNumber, int byteCount) {
        return WireOutput.tagSize(fieldNumber, WireType.LENGTH_DELIMITED) + WireOutput.int32Size(byteCount);
    }

    public static int writeMessageHeader(int fieldNumber, byte[] buffer, int bufferOffset, int byteCount) {
        int start = bufferOffset;
        bufferOffset += WireOutput.writeTag(fieldNumber, WireType.LENGTH_DELIMITED, buffer, bufferOffset);
        bufferOffset += WireOutput.writeVarint(byteCount, buffer, bufferOffset);
        return bufferOffset - start;
    }

    public static int makeTag(int fieldNumber, WireType wireType) {
        return fieldNumber << 3 | wireType.value();
    }

    private WireOutput(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.position = offset;
        this.limit = offset + length;
    }

    static WireOutput newInstance(byte[] flatArray) {
        return WireOutput.newInstance(flatArray, 0, flatArray.length);
    }

    static WireOutput newInstance(byte[] flatArray, int offset, int length) {
        return new WireOutput(flatArray, offset, length);
    }

    static int varintTagSize(int tag) {
        return WireOutput.varint32Size(WireOutput.makeTag(tag, WireType.VARINT));
    }

    static int varint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    static int varint64Size(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    void writeRawByte(byte value) throws IOException {
        if (this.position == this.limit) {
            throw new IOException("Out of space: position=" + this.position + ", limit=" + this.limit);
        }
        this.buffer[this.position++] = value;
    }

    void writeRawByte(int value) throws IOException {
        this.writeRawByte((byte)value);
    }

    void writeRawBytes(byte[] value) throws IOException {
        this.writeRawBytes(value, 0, value.length);
    }

    void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        if (this.limit - this.position >= length) {
            System.arraycopy(value, offset, this.buffer, this.position, length);
            this.position += length;
        } else {
            throw new IOException("Out of space: position=" + this.position + ", limit=" + this.limit);
        }
    }

    void writeTag(int fieldNumber, WireType wireType) throws IOException {
        this.writeVarint32(WireOutput.makeTag(fieldNumber, wireType));
    }

    void writeSignedVarint32(int value) throws IOException {
        if (value >= 0) {
            this.writeVarint32(value);
        } else {
            this.writeVarint64(value);
        }
    }

    void writeVarint32(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeRawByte(value);
                return;
            }
            this.writeRawByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    void writeVarint64(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)value);
                return;
            }
            this.writeRawByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    void writeFixed32(int value) throws IOException {
        this.writeRawByte(value & 0xFF);
        this.writeRawByte(value >> 8 & 0xFF);
        this.writeRawByte(value >> 16 & 0xFF);
        this.writeRawByte(value >> 24 & 0xFF);
    }

    void writeFixed64(long value) throws IOException {
        this.writeRawByte((int)value & 0xFF);
        this.writeRawByte((int)(value >> 8) & 0xFF);
        this.writeRawByte((int)(value >> 16) & 0xFF);
        this.writeRawByte((int)(value >> 24) & 0xFF);
        this.writeRawByte((int)(value >> 32) & 0xFF);
        this.writeRawByte((int)(value >> 40) & 0xFF);
        this.writeRawByte((int)(value >> 48) & 0xFF);
        this.writeRawByte((int)(value >> 56) & 0xFF);
    }

    static int zigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    static long zigZag64(long n) {
        return n << 1 ^ n >> 63;
    }
}

