/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.FieldBinding;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class RuntimeMessageAdapter<M extends Message<M, B>, B extends Message.Builder<M, B>>
extends ProtoAdapter<M> {
    private static final String REDACTED = "\u2588\u2588";
    private final Class<M> messageType;
    private final Class<B> builderType;
    private final Map<Integer, FieldBinding<M, B>> fieldBindings;

    static <M extends Message<M, B>, B extends Message.Builder<M, B>> RuntimeMessageAdapter<M, B> create(Class<M> messageType) {
        Class<B> builderType = RuntimeMessageAdapter.getBuilderType(messageType);
        LinkedHashMap fieldBindings = new LinkedHashMap();
        for (Field messageField : messageType.getDeclaredFields()) {
            WireField wireField = messageField.getAnnotation(WireField.class);
            if (wireField == null) continue;
            fieldBindings.put(wireField.tag(), new FieldBinding(wireField, messageField, builderType));
        }
        return new RuntimeMessageAdapter<M, B>(messageType, builderType, Collections.unmodifiableMap(fieldBindings));
    }

    RuntimeMessageAdapter(Class<M> messageType, Class<B> builderType, Map<Integer, FieldBinding<M, B>> fieldBindings) {
        super(FieldEncoding.LENGTH_DELIMITED, messageType);
        this.messageType = messageType;
        this.builderType = builderType;
        this.fieldBindings = fieldBindings;
    }

    Map<Integer, FieldBinding<M, B>> fieldBindings() {
        return this.fieldBindings;
    }

    B newBuilder() {
        try {
            return (B)((Message.Builder)this.builderType.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static <M extends Message<M, B>, B extends Message.Builder<M, B>> Class<B> getBuilderType(Class<M> messageType) {
        try {
            return Class.forName(messageType.getName() + "$Builder");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No builder class found for message type " + messageType.getName());
        }
    }

    @Override
    public int encodedSize(M message) {
        int cachedSerializedSize = ((Message)message).cachedSerializedSize;
        if (cachedSerializedSize != 0) {
            return cachedSerializedSize;
        }
        int size = 0;
        for (FieldBinding<M, B> fieldBinding : this.fieldBindings.values()) {
            Object value = fieldBinding.get(message);
            if (value == null) continue;
            size += fieldBinding.adapter().encodedSizeWithTag(fieldBinding.tag, value);
        }
        ((Message)message).cachedSerializedSize = size += ((Message)message).unknownFields().size();
        return size;
    }

    @Override
    public void encode(ProtoWriter writer, M message) throws IOException {
        for (FieldBinding<M, B> fieldBinding : this.fieldBindings.values()) {
            Object value = fieldBinding.get(message);
            if (value == null) continue;
            fieldBinding.adapter().encodeWithTag(writer, fieldBinding.tag, value);
        }
        writer.writeBytes(((Message)message).unknownFields());
    }

    @Override
    public M redact(M message) {
        Object builder = ((Message)message).newBuilder();
        for (FieldBinding fieldBinding : this.fieldBindings.values()) {
            if (fieldBinding.redacted && fieldBinding.label == WireField.Label.REQUIRED) {
                throw new UnsupportedOperationException(String.format("Field '%s' in %s is required and cannot be redacted.", fieldBinding.name, this.javaType.getName()));
            }
            boolean isMessage = Message.class.isAssignableFrom(fieldBinding.singleAdapter().javaType);
            if (fieldBinding.redacted || isMessage && !fieldBinding.label.isRepeated()) {
                Object builderValue = fieldBinding.getFromBuilder(builder);
                if (builderValue == null) continue;
                Object redactedValue = fieldBinding.adapter().redact(builderValue);
                fieldBinding.set(builder, redactedValue);
                continue;
            }
            if (!isMessage || !fieldBinding.label.isRepeated()) continue;
            List values = (List)fieldBinding.getFromBuilder(builder);
            ProtoAdapter<?> adapter = fieldBinding.singleAdapter();
            Internal.redactElements(values, adapter);
        }
        ((Message.Builder)builder).clearUnknownFields();
        return ((Message.Builder)builder).build();
    }

    public boolean equals(Object o) {
        return o instanceof RuntimeMessageAdapter && ((RuntimeMessageAdapter)o).messageType == this.messageType;
    }

    public int hashCode() {
        return this.messageType.hashCode();
    }

    @Override
    public String toString(M message) {
        StringBuilder sb = new StringBuilder();
        for (FieldBinding<M, B> fieldBinding : this.fieldBindings.values()) {
            Object value = fieldBinding.get(message);
            if (value == null) continue;
            sb.append(", ").append(fieldBinding.name).append('=').append(fieldBinding.redacted ? REDACTED : value);
        }
        sb.replace(0, 2, this.messageType.getSimpleName() + '{');
        return sb.append('}').toString();
    }

    @Override
    public M decode(ProtoReader reader) throws IOException {
        int tag;
        B builder = this.newBuilder();
        long token = reader.beginMessage();
        while ((tag = reader.nextTag()) != -1) {
            FieldBinding<M, B> fieldBinding = this.fieldBindings.get(tag);
            try {
                Object value;
                if (fieldBinding != null) {
                    ProtoAdapter<Object> adapter = fieldBinding.isMap() ? fieldBinding.adapter() : fieldBinding.singleAdapter();
                    value = adapter.decode(reader);
                    fieldBinding.value(builder, value);
                    continue;
                }
                FieldEncoding fieldEncoding = reader.peekFieldEncoding();
                value = fieldEncoding.rawProtoAdapter().decode(reader);
                ((Message.Builder)builder).addUnknownField(tag, fieldEncoding, value);
            }
            catch (ProtoAdapter.EnumConstantNotFoundException e) {
                ((Message.Builder)builder).addUnknownField(tag, FieldEncoding.VARINT, e.value);
            }
        }
        reader.endMessage(token);
        return ((Message.Builder)builder).build();
    }
}

