[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [EmittingRules](./index.md)

# EmittingRules

`class EmittingRules`

A set of rules that describes which types to generate.

Despite the builder, instances of this class are not safe for concurrent use.

### Identifier Matching

Identifiers in this set may be in the following forms:

* Package names, followed by `.*`, like `squareup.protos.person.*`. This matches types and
    services defined in the package and its descendant packages.

* Fully qualified type and service names, like `squareup.protos.person.Person`.

Identifiers should not contain member names.

This set has *included identifiers* and *excluded identifiers*, with the most precise identifier
taking precedence over the other ones. For instance, if there is one included identifier
`a.Movie` along an excluded identifier `a.*`, the type `a.Movie` is considered included in the
set.

If the includes set is empty, that implies that all elements should be included. Use this to
exclude unwanted types and members without also including everything else.

### Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | `class Builder` |

### Properties

| Name | Summary |
|---|---|
| [isEmpty](is-empty.md) | `val isEmpty: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |

### Functions

| Name | Summary |
|---|---|
| [includes](includes.md) | `fun includes(type: <ERROR CLASS>): <ERROR CLASS>`<br>Returns true if `type` should be generated. |
| [unusedExcludes](unused-excludes.md) | `fun unusedExcludes(): <ERROR CLASS>` |
| [unusedIncludes](unused-includes.md) | `fun unusedIncludes(): <ERROR CLASS>` |
