[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [EnclosingType](./index.md)

# EnclosingType

`class EnclosingType : `[`Type`](../-type/index.md)

An empty type which only holds nested types.

### Properties

| Name | Summary |
|---|---|
| [documentation](documentation.md) | `val documentation: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [location](location.md) | `val location: `[`Location`](../-location/index.md) |
| [nestedTypes](nested-types.md) | `val nestedTypes: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Type`](../-type/index.md)`>` |
| [options](options.md) | `val options: `[`Options`](../-options/index.md) |
| [type](type.md) | `val type: `[`ProtoType`](../-proto-type/index.md) |

### Functions

| Name | Summary |
|---|---|
| [linkMembers](link-members.md) | `fun linkMembers(linker: `[`Linker`](../-linker/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [linkOptions](link-options.md) | `fun linkOptions(linker: `[`Linker`](../-linker/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [retainAll](retain-all.md) | `fun retainAll(schema: `[`Schema`](../-schema/index.md)`, markSet: `[`MarkSet`](../-mark-set/index.md)`): `[`Type`](../-type/index.md)`?` |
| [retainLinked](retain-linked.md) | `fun retainLinked(linkedTypes: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`ProtoType`](../-proto-type/index.md)`>): `[`Type`](../-type/index.md)`?`<br>Returns a copy of this containing only the types in [linkedTypes](../-type/retain-linked.md#com.squareup.wire.schema.Type$retainLinked(kotlin.collections.Set((com.squareup.wire.schema.ProtoType)))/linkedTypes), or null if that set is empty. This will return an [EnclosingType](./index.md) if it is itself not linked, but its nested types are linked. |
| [toElement](to-element.md) | `fun toElement(): `[`MessageElement`](../../com.squareup.wire.schema.internal.parser/-message-element/index.md) |
| [validate](validate.md) | `fun validate(linker: `[`Linker`](../-linker/index.md)`, syntaxRules: `[`SyntaxRules`](../-syntax-rules/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Inherited Functions

| Name | Summary |
|---|---|
| [typesAndNestedTypes](../-type/types-and-nested-types.md) | `fun typesAndNestedTypes(): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Type`](../-type/index.md)`>`<br>Returns all types and subtypes which are linked to the type. |
