[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [SchemaLoader](./index.md)

# SchemaLoader

`class SchemaLoader`

Load proto files and their transitive dependencies, parse them, and link them together.

To find proto files to load, a non-empty set of sources are searched. Each source is either a
regular directory or a ZIP file. Within ZIP files, proto files are expected to be found relative
to the root of the archive.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `SchemaLoader()`<br>Load proto files and their transitive dependencies, parse them, and link them together. |

### Properties

| Name | Summary |
|---|---|
| [protos](protos.md) | `val protos: <ERROR CLASS>`<br>Returns a mutable list of the proto paths that this loader will load. |
| [sources](sources.md) | `val sources: <ERROR CLASS>`<br>Returns a mutable list of the sources that this loader will load from. |

### Functions

| Name | Summary |
|---|---|
| [addProto](add-proto.md) | `fun addProto(proto: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): <ERROR CLASS>`<br>Add a proto file path to load. Dependencies will be loaded automatically from the configured sources. |
| [addSource](add-source.md) | `fun addSource(file: `[`File`](http://docs.oracle.com/javase/8/docs/api/java/io/File.html)`): <ERROR CLASS>`<br>`fun addSource(path: `[`Path`](http://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html)`): <ERROR CLASS>`<br>Add directory or zip file source from which proto files will be loaded. |
| [load](load.md) | `fun load(): <ERROR CLASS>` |
