[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [Schema](./index.md)

# Schema

`class Schema`

A collection of .proto files that describe a set of messages. A schema is *linked*: each
field's type name is resolved to the corresponding type definition.

Use [SchemaLoader](#) to load a schema from source files.

### Properties

| Name | Summary |
|---|---|
| [protoFiles](proto-files.md) | `val protoFiles: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`ProtoFile`](../-proto-file/index.md)`>` |

### Functions

| Name | Summary |
|---|---|
| [getField](get-field.md) | `fun getField(protoMember: `[`ProtoMember`](../-proto-member/index.md)`): `[`Field`](../-field/index.md)`?`<br>Returns the field for [protoMember](get-field.md#com.squareup.wire.schema.Schema$getField(com.squareup.wire.schema.ProtoMember)/protoMember), or null if this schema defines no such field.`fun getField(typeName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, memberName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Field`](../-field/index.md)`?`<br>Returns the field with the fully qualified [typeName](get-field.md#com.squareup.wire.schema.Schema$getField(kotlin.String, kotlin.String)/typeName) and [memberName](get-field.md#com.squareup.wire.schema.Schema$getField(kotlin.String, kotlin.String)/memberName), or null if this schema defines no such field.`fun getField(protoType: `[`ProtoType`](../-proto-type/index.md)`, memberName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Field`](../-field/index.md)`?`<br>Returns the field for [protoType](get-field.md#com.squareup.wire.schema.Schema$getField(com.squareup.wire.schema.ProtoType, kotlin.String)/protoType) and [memberName](get-field.md#com.squareup.wire.schema.Schema$getField(com.squareup.wire.schema.ProtoType, kotlin.String)/memberName), or null if this schema defines no such field. |
| [getService](get-service.md) | `fun getService(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Service`](../-service/index.md)`?`<br>Returns the service with the fully qualified name [name](get-service.md#com.squareup.wire.schema.Schema$getService(kotlin.String)/name), or null if this schema defines no such service.`fun getService(protoType: `[`ProtoType`](../-proto-type/index.md)`): `[`Service`](../-service/index.md)`?`<br>Returns the service for [protoType](get-service.md#com.squareup.wire.schema.Schema$getService(com.squareup.wire.schema.ProtoType)/protoType), or null if this schema defines no such service. |
| [getType](get-type.md) | `fun getType(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Type`](../-type/index.md)`?`<br>Returns the type with the fully qualified name [name](get-type.md#com.squareup.wire.schema.Schema$getType(kotlin.String)/name), or null if this schema defines no such type.`fun getType(protoType: `[`ProtoType`](../-proto-type/index.md)`): `[`Type`](../-type/index.md)`?`<br>Returns the type for [protoType](get-type.md#com.squareup.wire.schema.Schema$getType(com.squareup.wire.schema.ProtoType)/protoType), or null if this schema defines no such type. |
| [isExtensionField](is-extension-field.md) | `fun isExtensionField(protoMember: `[`ProtoMember`](../-proto-member/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [protoAdapter](proto-adapter.md) | `fun protoAdapter(typeName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, includeUnknown: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`): <ERROR CLASS><`[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`<br>Returns a wire adapter for the message or enum type named [typeName](proto-adapter.md#com.squareup.wire.schema.Schema$protoAdapter(kotlin.String, kotlin.Boolean)/typeName). The returned type adapter doesn't have model classes to encode and decode from, so instead it uses scalar types ([String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [ByteString](#), [Integer](http://docs.oracle.com/javase/8/docs/api/java/lang/Integer.html), etc.), [maps](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html), and [lists](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html). It can both encode and decode these objects. Map keys are field names. |
| [protoFile](proto-file.md) | `fun protoFile(path: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`ProtoFile`](../-proto-file/index.md)`?`<br>Returns the proto file at [path](proto-file.md#com.squareup.wire.schema.Schema$protoFile(kotlin.String)/path), or null if this schema has no such file.`fun protoFile(protoType: `[`ProtoType`](../-proto-type/index.md)`): `[`ProtoFile`](../-proto-file/index.md)`?`<br>Returns the proto file containing this [protoType](proto-file.md#com.squareup.wire.schema.Schema$protoFile(com.squareup.wire.schema.ProtoType)/protoType), or null if there isn't such file. |
| [prune](prune.md) | `fun prune(pruningRules: `[`PruningRules`](../-pruning-rules/index.md)`): `[`Schema`](./index.md)<br>Returns a copy of this schema that retains only the types and services selected by [pruningRules](prune.md#com.squareup.wire.schema.Schema$prune(com.squareup.wire.schema.PruningRules)/pruningRules), plus their transitive dependencies. |

### Companion Object Functions

| Name | Summary |
|---|---|
| [fromFiles](from-files.md) | `fun fromFiles(sourceProtoFiles: `[`Iterable`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)`<`[`ProtoFile`](../-proto-file/index.md)`>, pathFilesLoader: `[`Loader`](../-loader/index.md)` = CoreLoader): `[`Schema`](./index.md) |
