[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [Type](./index.md)

# Type

`abstract class Type`

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Type()` |

### Properties

| Name | Summary |
|---|---|
| [documentation](documentation.md) | `abstract val documentation: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [location](location.md) | `abstract val location: `[`Location`](../-location/index.md) |
| [nestedTypes](nested-types.md) | `abstract val nestedTypes: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Type`](./index.md)`>` |
| [options](options.md) | `abstract val options: `[`Options`](../-options/index.md) |
| [type](type.md) | `abstract val type: `[`ProtoType`](../-proto-type/index.md) |

### Functions

| Name | Summary |
|---|---|
| [linkMembers](link-members.md) | `abstract fun linkMembers(linker: `[`Linker`](../-linker/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [linkOptions](link-options.md) | `abstract fun linkOptions(linker: `[`Linker`](../-linker/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [retainAll](retain-all.md) | `abstract fun retainAll(schema: `[`Schema`](../-schema/index.md)`, markSet: `[`MarkSet`](../-mark-set/index.md)`): `[`Type`](./index.md)`?` |
| [retainLinked](retain-linked.md) | `abstract fun retainLinked(linkedTypes: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`ProtoType`](../-proto-type/index.md)`>): `[`Type`](./index.md)`?`<br>Returns a copy of this containing only the types in [linkedTypes](retain-linked.md#com.squareup.wire.schema.Type$retainLinked(kotlin.collections.Set((com.squareup.wire.schema.ProtoType)))/linkedTypes), or null if that set is empty. This will return an [EnclosingType](../-enclosing-type/index.md) if it is itself not linked, but its nested types are linked. |
| [typesAndNestedTypes](types-and-nested-types.md) | `fun typesAndNestedTypes(): `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Type`](./index.md)`>`<br>Returns all types and subtypes which are linked to the type. |
| [validate](validate.md) | `abstract fun validate(linker: `[`Linker`](../-linker/index.md)`, syntaxRules: `[`SyntaxRules`](../-syntax-rules/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [fromElements](from-elements.md) | `fun fromElements(packageName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, elements: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`TypeElement`](../../com.squareup.wire.schema.internal.parser/-type-element/index.md)`>): <ERROR CLASS>` |
| [get](get.md) | `operator fun get(packageName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, protoType: `[`ProtoType`](../-proto-type/index.md)`, type: `[`TypeElement`](../../com.squareup.wire.schema.internal.parser/-type-element/index.md)`): `[`Type`](./index.md) |
| [toElements](to-elements.md) | `fun toElements(types: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<`[`Type`](./index.md)`>): <ERROR CLASS>` |

### Inheritors

| Name | Summary |
|---|---|
| [EnclosingType](../-enclosing-type/index.md) | `class EnclosingType : `[`Type`](./index.md)<br>An empty type which only holds nested types. |
| [EnumType](../-enum-type/index.md) | `class EnumType : `[`Type`](./index.md) |
| [MessageType](../-message-type/index.md) | `class MessageType : `[`Type`](./index.md) |
