[wire-schema](../../index.md) / [com.squareup.wire.schema.internal.parser](../index.md) / [SyntaxReader](./index.md)

# SyntaxReader

`class SyntaxReader`

A general purpose reader for formats like `.proto`.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `SyntaxReader(data: `[`CharArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char-array/index.html)`, location: `[`Location`](../../com.squareup.wire.schema/-location/index.md)`)`<br>A general purpose reader for formats like `.proto`. |

### Functions

| Name | Summary |
|---|---|
| [exhausted](exhausted.md) | `fun exhausted(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [expect](expect.md) | `fun expect(condition: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)`, location: `[`Location`](../../com.squareup.wire.schema/-location/index.md)` = location(), message: () -> `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [location](location.md) | `fun location(): `[`Location`](../../com.squareup.wire.schema/-location/index.md) |
| [peekChar](peek-char.md) | `fun peekChar(): `[`Char`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char/index.html)<br>Peeks a non-whitespace character and returns it. The only difference between this and [readChar](read-char.md) is that this doesn't consume the char.`fun peekChar(c: `[`Char`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [pushBack](push-back.md) | `fun pushBack(c: `[`Char`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Push back the most recently read character. |
| [readChar](read-char.md) | `fun readChar(): `[`Char`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char/index.html)<br>Reads a non-whitespace character and returns it. |
| [readDataType](read-data-type.md) | `fun readDataType(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Reads a scalar, map, or type name.`fun readDataType(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Reads a scalar, map, or type name with `name` as a prefix word. |
| [readDocumentation](read-documentation.md) | `fun readDocumentation(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Like [skipWhitespace](#), but this returns a string containing all comment text. By convention, comments before a declaration document that declaration. |
| [readInt](read-int.md) | `fun readInt(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Reads an integer and returns it. |
| [readName](read-name.md) | `fun readName(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Reads a (paren-wrapped), [square-wrapped](#) or naked symbol name. |
| [readQuotedString](read-quoted-string.md) | `fun readQuotedString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [readString](read-string.md) | `fun readString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Reads a quoted or unquoted string and returns it. |
| [readWord](read-word.md) | `fun readWord(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Reads a non-empty word and returns it. |
| [require](require.md) | `fun require(c: `[`Char`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Reads a non-whitespace character 'c', or throws an exception. |
| [tryAppendTrailingDocumentation](try-append-trailing-documentation.md) | `fun tryAppendTrailingDocumentation(documentation: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [unexpected](unexpected.md) | `fun unexpected(message: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, location: `[`Location`](../../com.squareup.wire.schema/-location/index.md)`? = location()): `[`RuntimeException`](http://docs.oracle.com/javase/8/docs/api/java/lang/RuntimeException.html) |
