[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [ProtoType](./index.md)

# ProtoType

`class ProtoType`

Names a protocol buffer message, enumerated type, service, map, or a scalar. This class models a
fully-qualified name using the protocol buffer package.

### Properties

| Name | Summary |
|---|---|
| [enclosingTypeOrPackage](enclosing-type-or-package.md) | `val enclosingTypeOrPackage: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?`<br>Returns the enclosing type, or null if this type is not nested in another type. |
| [isMap](is-map.md) | `val isMap: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isScalar](is-scalar.md) | `val isScalar: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [keyType](key-type.md) | `val keyType: `[`ProtoType`](./index.md)`?`<br>The type of the map's keys. Only present when [isMap](is-map.md) is true. |
| [simpleName](simple-name.md) | `val simpleName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [typeUrl](type-url.md) | `val typeUrl: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?`<br>Returns a string like "type.googleapis.com/packagename.messagename" or null if this type is a scalar or a map. Note that this returns a non-null string for enums because it doesn't know if the named type is a message or an enum. |
| [valueType](value-type.md) | `val valueType: `[`ProtoType`](./index.md)`?`<br>The type of the map's values. Only present when [isMap](is-map.md) is true. |

### Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [nestedType](nested-type.md) | `fun nestedType(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`ProtoType`](./index.md) |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [ANY](-a-n-y.md) | `val ANY: `[`ProtoType`](./index.md) |
| [BOOL](-b-o-o-l.md) | `val BOOL: `[`ProtoType`](./index.md) |
| [BOOL_VALUE](-b-o-o-l_-v-a-l-u-e.md) | `val BOOL_VALUE: `[`ProtoType`](./index.md) |
| [BYTES](-b-y-t-e-s.md) | `val BYTES: `[`ProtoType`](./index.md) |
| [BYTES_VALUE](-b-y-t-e-s_-v-a-l-u-e.md) | `val BYTES_VALUE: `[`ProtoType`](./index.md) |
| [DOUBLE](-d-o-u-b-l-e.md) | `val DOUBLE: `[`ProtoType`](./index.md) |
| [DOUBLE_VALUE](-d-o-u-b-l-e_-v-a-l-u-e.md) | `val DOUBLE_VALUE: `[`ProtoType`](./index.md) |
| [DURATION](-d-u-r-a-t-i-o-n.md) | `val DURATION: `[`ProtoType`](./index.md) |
| [EMPTY](-e-m-p-t-y.md) | `val EMPTY: `[`ProtoType`](./index.md) |
| [FIXED32](-f-i-x-e-d32.md) | `val FIXED32: `[`ProtoType`](./index.md) |
| [FIXED64](-f-i-x-e-d64.md) | `val FIXED64: `[`ProtoType`](./index.md) |
| [FLOAT](-f-l-o-a-t.md) | `val FLOAT: `[`ProtoType`](./index.md) |
| [FLOAT_VALUE](-f-l-o-a-t_-v-a-l-u-e.md) | `val FLOAT_VALUE: `[`ProtoType`](./index.md) |
| [INT32](-i-n-t32.md) | `val INT32: `[`ProtoType`](./index.md) |
| [INT32_VALUE](-i-n-t32_-v-a-l-u-e.md) | `val INT32_VALUE: `[`ProtoType`](./index.md) |
| [INT64](-i-n-t64.md) | `val INT64: `[`ProtoType`](./index.md) |
| [INT64_VALUE](-i-n-t64_-v-a-l-u-e.md) | `val INT64_VALUE: `[`ProtoType`](./index.md) |
| [SFIXED32](-s-f-i-x-e-d32.md) | `val SFIXED32: `[`ProtoType`](./index.md) |
| [SFIXED64](-s-f-i-x-e-d64.md) | `val SFIXED64: `[`ProtoType`](./index.md) |
| [SINT32](-s-i-n-t32.md) | `val SINT32: `[`ProtoType`](./index.md) |
| [SINT64](-s-i-n-t64.md) | `val SINT64: `[`ProtoType`](./index.md) |
| [STRING](-s-t-r-i-n-g.md) | `val STRING: `[`ProtoType`](./index.md) |
| [STRING_VALUE](-s-t-r-i-n-g_-v-a-l-u-e.md) | `val STRING_VALUE: `[`ProtoType`](./index.md) |
| [STRUCT_LIST](-s-t-r-u-c-t_-l-i-s-t.md) | `val STRUCT_LIST: `[`ProtoType`](./index.md) |
| [STRUCT_MAP](-s-t-r-u-c-t_-m-a-p.md) | `val STRUCT_MAP: `[`ProtoType`](./index.md) |
| [STRUCT_NULL](-s-t-r-u-c-t_-n-u-l-l.md) | `val STRUCT_NULL: `[`ProtoType`](./index.md) |
| [STRUCT_VALUE](-s-t-r-u-c-t_-v-a-l-u-e.md) | `val STRUCT_VALUE: `[`ProtoType`](./index.md) |
| [TIMESTAMP](-t-i-m-e-s-t-a-m-p.md) | `val TIMESTAMP: `[`ProtoType`](./index.md) |
| [UINT32](-u-i-n-t32.md) | `val UINT32: `[`ProtoType`](./index.md) |
| [UINT32_VALUE](-u-i-n-t32_-v-a-l-u-e.md) | `val UINT32_VALUE: `[`ProtoType`](./index.md) |
| [UINT64](-u-i-n-t64.md) | `val UINT64: `[`ProtoType`](./index.md) |
| [UINT64_VALUE](-u-i-n-t64_-v-a-l-u-e.md) | `val UINT64_VALUE: `[`ProtoType`](./index.md) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [get](get.md) | `fun get(enclosingTypeOrPackage: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?, typeName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`ProtoType`](./index.md)<br>`fun get(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?): `[`ProtoType`](./index.md)<br>`fun get(keyType: `[`ProtoType`](./index.md)`, valueType: `[`ProtoType`](./index.md)`, name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`ProtoType`](./index.md) |
