[wire-grpc-client](../../index.md) / [com.squareup.wire](../index.md) / [GrpcStreamingCall](./index.md)

# GrpcStreamingCall

`interface GrpcStreamingCall<S : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, R : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

A single streaming call to a remote server. This class handles three streaming call types:

* Single request, streaming response. The send channel or message sink accept exactly one
    message. The receive channel or message source produce zero or more messages. The outbound
    request message is sent before any inbound response messages.

* Streaming request, single response. The send channel or message sink accept zero or more
    messages. The receive channel or message source produce exactly one message. All outbound
    request messages are sent before the inbound response message.

* Streaming request, streaming response. The send channel or message sink accept zero or more
    messages, and the receive channel or message source produce any number of messages. Unlike
    the above two types, you are free to interleave request and response messages.

A gRPC call cannot be executed twice.

gRPC calls can be [suspending](execute-in.md) or [blocking](execute-blocking.md). Use whichever mechanism
works at your call site: the bytes transmitted on the network are the same.

### Properties

| Name | Summary |
|---|---|
| [timeout](timeout.md) | `abstract val timeout: <ERROR CLASS>`<br>Configures how long the call can take to complete before it is automatically canceled. The timeout applies to the full set of messages transmitted. For long-running streams you must configure a sufficiently long timeout. |

### Functions

| Name | Summary |
|---|---|
| [cancel](cancel.md) | `abstract fun cancel(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Attempts to cancel the call. This function is safe to call concurrently with execution. When canceled, execution fails with an immediate [IOException](#) rather than waiting to complete normally. |
| [clone](clone.md) | `abstract fun clone(): `[`GrpcStreamingCall`](./index.md)`<`[`S`](index.md#S)`, `[`R`](index.md#R)`>`<br>Create a new, identical gRPC call to this one which can be enqueued or executed even if this call has already been. |
| [executeBlocking](execute-blocking.md) | `abstract fun executeBlocking(): <ERROR CLASS><<ERROR CLASS><`[`S`](index.md#S)`>, <ERROR CLASS><`[`R`](index.md#R)`>>`<br>Enqueues this call for execution and returns streams to send and receive the call's messages. Reads and writes on the returned streams are blocking. |
| [executeIn](execute-in.md) | `abstract fun executeIn(scope: <ERROR CLASS>): <ERROR CLASS><<ERROR CLASS><`[`S`](index.md#S)`>, <ERROR CLASS><`[`R`](index.md#R)`>>`<br>Enqueues this call for execution and returns channels to send and receive the call's messages. This uses the [Dispatchers.IO](#) to transmit outbound messages. |
| [isCanceled](is-canceled.md) | `abstract fun isCanceled(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>True if [cancel](cancel.md) was called. |
| [isExecuted](is-executed.md) | `abstract fun isExecuted(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [executeIn](execute-in.md) or [executeBlocking](execute-blocking.md) was called. It is an error to execute a call more than once. |
