[wire-runtime](../../index.md) / [com.squareup.wire](../index.md) / [ProtoWriter](./index.md)

# ProtoWriter

`class ProtoWriter`

Utilities for encoding and writing protocol message fields.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ProtoWriter(sink: <ERROR CLASS>)`<br>Utilities for encoding and writing protocol message fields. |

### Functions

| Name | Summary |
|---|---|
| [writeBytes](write-bytes.md) | `fun writeBytes(value: <ERROR CLASS>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [writeFixed32](write-fixed32.md) | `fun writeFixed32(value: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Write a little-endian 32-bit integer. |
| [writeFixed64](write-fixed64.md) | `fun writeFixed64(value: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Write a little-endian 64-bit integer. |
| [writeString](write-string.md) | `fun writeString(value: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [writeTag](write-tag.md) | `fun writeTag(fieldNumber: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, fieldEncoding: `[`FieldEncoding`](../-field-encoding/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Encode and write a tag. |
| [writeVarint32](write-varint32.md) | `fun writeVarint32(value: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Encode and write a varint. `value` is treated as unsigned, so it won't be sign-extended if negative. |
| [writeVarint64](write-varint64.md) | `fun writeVarint64(value: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Encode and write a varint. |
