[wire-runtime](../index.md) / [com.squareup.wire](./index.md)

## Package com.squareup.wire

### Types

| Name | Summary |
|---|---|
| [AndroidMessage](-android-message/index.md)<br>(JVM) | `abstract class AndroidMessage<M : `[`Message`](-message/index.md)`<`[`M`](-android-message/index.md#M)`, `[`B`](-android-message/index.md#B)`>, B : `[`Builder`](-message/-builder/index.md)`<`[`M`](-android-message/index.md#M)`, `[`B`](-android-message/index.md#B)`>> : `[`Message`](-message/index.md)`<`[`M`](-android-message/index.md#M)`, `[`B`](-android-message/index.md#B)`>`<br>An Android-specific [Message](-message/index.md) which adds support for [Parcelable](#). |
| [AnyMessage](-any-message/index.md) | `class AnyMessage : `[`Message`](-message/index.md)`<`[`AnyMessage`](-any-message/index.md)`, `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>`<br>Wire implementation of the `google.protobuf.Any` type. The `Any` type wraps an arbitrary protobuf message. Field of `Any` generated by Wire will be typed [AnyMessage](-any-message/index.md). [typeUrl](-any-message/type-url.md) is used to identify the type of the message, defined as 'type.googleapis.com/full.type.name'. [value](-any-message/value.md) is the serialized representation of the wrapped message. The [pack](-any-message/pack.md) and [unpack](-any-message/unpack.md) methods are available to wrap and unwrap an `Any` message. |
| [Duration](-duration/index.md) | `expect class Duration`<br>A measurement of time. Durations may be positive, zero, or negative. |
| [EnumAdapter](-enum-adapter/index.md)<br>(JVM, js, native) | `abstract expect class EnumAdapter<E : `[`WireEnum`](-wire-enum/index.md)`> : `[`ProtoAdapter`](-proto-adapter/index.md)`<`[`E`](-enum-adapter/index.md#E)`>`<br>An abstract [ProtoAdapter](-proto-adapter/index.md) that converts values of an enum to and from integers. |
| [FieldEncoding](-field-encoding/index.md) | `enum class FieldEncoding` |
| [Instant](-instant/index.md) | `expect class Instant`<br>This represents a timestamp, though we use the name 'instant' in the runtime because that's what the JVM libraries use, and 'Timestamp' means something else on that platform. |
| [Message](-message/index.md)<br>(JVM, js, native) | `abstract expect class Message<M : `[`Message`](-message/index.md)`<`[`M`](-message/index.md#M)`, `[`B`](-message/index.md#B)`>, B : `[`Builder`](-message/-builder/index.md)`<`[`M`](-message/index.md#M)`, `[`B`](-message/index.md#B)`>>`<br>A protocol buffer message. |
| [MessageSink](-message-sink/index.md)<br>(JVM, js, native) | `expect interface MessageSink<in T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`<br>A writable stream of messages. |
| [MessageSource](-message-source/index.md)<br>(JVM, js, native) | `expect interface MessageSource<out T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`<br>A readable stream of messages. |
| [ProtoAdapter](-proto-adapter/index.md)<br>(JVM, js, native) | `abstract expect class ProtoAdapter<E>` |
| [ProtoReader](-proto-reader/index.md) | `class ProtoReader`<br>Reads and decodes protocol message fields. |
| [ProtoWriter](-proto-writer/index.md) | `class ProtoWriter`<br>Utilities for encoding and writing protocol message fields. |
| [Service](-service.md) | `interface Service` |
| [Syntax](-syntax/index.md) | `enum class Syntax`<br>Syntax version. |
| [WireEnum](-wire-enum/index.md) | `interface WireEnum`<br>Interface for generated [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html) values to help serialization and deserialization. |

### Annotations

| Name | Summary |
|---|---|
| [WireField](-wire-field/index.md) | `annotation class WireField`<br>Annotates generated [Message](-message/index.md) fields with metadata for serialization and deserialization. |
| [WireRpc](-wire-rpc/index.md) | `annotation class WireRpc`<br>For gRPC actions the path is formatted as `/<service name>/<method name>`. The path of the proto service below is `/squareup.helloworld.Greeter/SayHello`. |

### Type Aliases

| Name | Summary |
|---|---|
| [Duration](-duration/index.md)<br>(JVM) | `actual typealias Duration = `[`Duration`](http://docs.oracle.com/javase/8/docs/api/java/time/Duration.html) |
| [Instant](-instant/index.md)<br>(JVM) | `actual typealias Instant = `[`Instant`](http://docs.oracle.com/javase/8/docs/api/java/time/Instant.html) |

### Functions

| Name | Summary |
|---|---|
| [durationOfSeconds](duration-of-seconds.md)<br>(JVM, js, native) | `expect fun durationOfSeconds(seconds: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, nano: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Duration`](-duration/index.md) |
| [get](get.md)<br>(JVM) | `fun <T> get(value: `[`T`](get.md#T)`?, defaultValue: `[`T`](get.md#T)`): `[`T`](get.md#T)<br>Returns `value` if it is not null; `defaultValue` otherwise. This is used to conveniently return a default value when a value is null. For example, |
| [ofEpochSecond](of-epoch-second.md)<br>(JVM, js, native) | `expect fun ofEpochSecond(epochSecond: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`, nano: `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)`): `[`Instant`](-instant/index.md) |
