[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [ErrorCollector](./index.md)

# ErrorCollector

`class ErrorCollector`

Collects errors to be reported as a batch. Errors include both a detail message plus context of
where they occurred within the schema.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ErrorCollector()` |

### Functions

| Name | Summary |
|---|---|
| [at](at.md) | `fun at(additionalContext: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`): `[`ErrorCollector`](./index.md)<br>Returns a copy of this error collector that includes [additionalContext](at.md#com.squareup.wire.schema.ErrorCollector$at(kotlin.Any)/additionalContext) in error messages reported to it. The current and returned instance both contribute errors to the same list. |
| [plusAssign](plus-assign.md) | `operator fun plusAssign(message: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Add [message](plus-assign.md#com.squareup.wire.schema.ErrorCollector$plusAssign(kotlin.String)/message) as an error to this collector. |
| [throwIfNonEmpty](throw-if-non-empty.md) | `fun throwIfNonEmpty(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
