[wire-moshi-adapter](../../index.md) / [com.squareup.wire](../index.md) / [WireJsonAdapterFactory](./index.md)

# WireJsonAdapterFactory

`class WireJsonAdapterFactory : Factory`

A [JsonAdapter.Factory](#) that allows Wire messages to be serialized and deserialized using the
Moshi Json library.

```
Moshi moshi = new Moshi.Builder()
    .add(new WireJsonAdapterFactory())
    .build();
```

The resulting [Moshi](#) instance will be able to serialize and deserialize Wire [Message](#) types,
including extensions. It ignores unknown field values. The JSON encoding is intended to be
compatible with the [protobuf-java-format](https://code.google.com/p/protobuf-java-format/)
library.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `WireJsonAdapterFactory()` |

### Functions

| Name | Summary |
|---|---|
| [create](create.md) | `fun create(type: `[`Type`](http://docs.oracle.com/javase/6/docs/api/java/lang/reflect/Type.html)`, annotations: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Annotation`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)`>, moshi: Moshi): JsonAdapter<*>?` |
| [plus](plus.md) | `fun plus(adapters: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ProtoAdapter<*>>): `[`WireJsonAdapterFactory`](./index.md)<br>Returns a new WireJsonAdapterFactory that can encode the messages for [adapters](plus.md#com.squareup.wire.WireJsonAdapterFactory$plus(kotlin.collections.List((com.squareup.wire.ProtoAdapter((kotlin.Any)))))/adapters) if they're used with [AnyMessage](#).`fun plus(adapter: ProtoAdapter<*>): `[`WireJsonAdapterFactory`](./index.md)<br>Returns a new WireJsonAdapterFactory that can encode the messages for [adapter](plus.md#com.squareup.wire.WireJsonAdapterFactory$plus(com.squareup.wire.ProtoAdapter((kotlin.Any)))/adapter) if they're used with [AnyMessage](#). |
