[wire-runtime](../../index.md) / [com.squareup.wire](../index.md) / [Message](./index.md)

# Message

`abstract expect class Message<M : `[`Message`](./index.md)`<`[`M`](index.md#M)`, `[`B`](index.md#B)`>, B : `[`Builder`](-builder/index.md)`<`[`M`](index.md#M)`, `[`B`](index.md#B)`>>`

**Platform and version requirements:** JVM, js, native

A protocol buffer message.

### Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md)<br>(JVM, js, native) | `abstract class Builder<M : `[`Message`](./index.md)`<`[`M`](-builder/index.md#M)`, `[`B`](-builder/index.md#B)`>, B : `[`Builder`](-builder/index.md)`<`[`M`](-builder/index.md#M)`, `[`B`](-builder/index.md#B)`>>`<br>Superclass for protocol buffer message builders. |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Message(adapter: `[`ProtoAdapter`](../-proto-adapter/index.md)`<`[`M`](index.md#M)`>, unknownFields: <ERROR CLASS>)`<br>A protocol buffer message. |

### Properties

| Name | Summary |
|---|---|
| [adapter](adapter.md) | `val adapter: `[`ProtoAdapter`](../-proto-adapter/index.md)`<`[`M`](index.md#M)`>`<br>The [ProtoAdapter](../-proto-adapter/index.md) for encoding and decoding messages of this type. |
| [hashCode](hash-code.md) | `var hashCode: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>If non-zero, the hash code of this message. Accessed by generated code. |
| [unknownFields](unknown-fields.md) | `val unknownFields: <ERROR CLASS>`<br>Returns a byte string containing the proto encoding of this message's unknown fields. Returns an empty byte string if this message has no unknown fields. |

### Functions

| Name | Summary |
|---|---|
| [encode](encode.md) | `fun encode(sink: <ERROR CLASS>): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>`fun encode(stream: `[`OutputStream`](http://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Encode this message and write it to `stream`.`fun encode(): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Encode this message as a `byte[]`. |
| [encodeByteString](encode-byte-string.md) | `fun encodeByteString(): <ERROR CLASS>`<br>Encode this message as a `ByteString`. |
| [newBuilder](new-builder.md) | `abstract fun newBuilder(): `[`B`](index.md#B)<br>Returns a new builder initialized with the data in this message. |
| [toString](to-string.md) | `open fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [withoutUnknownFields](without-unknown-fields.md)<br>(JVM) | `fun withoutUnknownFields(): `[`M`](index.md#M)<br>Returns this message with any unknown fields removed. |
| [writeReplace](write-replace.md)<br>(JVM) | `fun writeReplace(): `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html) |

### Inheritors

| Name | Summary |
|---|---|
| [AndroidMessage](../-android-message/index.md)<br>(JVM) | `abstract class AndroidMessage<M : `[`Message`](./index.md)`<`[`M`](../-android-message/index.md#M)`, `[`B`](../-android-message/index.md#B)`>, B : `[`Builder`](-builder/index.md)`<`[`M`](../-android-message/index.md#M)`, `[`B`](../-android-message/index.md#B)`>> : `[`Message`](./index.md)`<`[`M`](../-android-message/index.md#M)`, `[`B`](../-android-message/index.md#B)`>`<br>An Android-specific [Message](./index.md) which adds support for [Parcelable](#). |
| [AnyMessage](../-any-message/index.md) | `class AnyMessage : `[`Message`](./index.md)`<`[`AnyMessage`](../-any-message/index.md)`, `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>`<br>Wire implementation of the `google.protobuf.Any` type. The `Any` type wraps an arbitrary protobuf message. Field of `Any` generated by Wire will be typed [AnyMessage](../-any-message/index.md). [typeUrl](../-any-message/type-url.md) is used to identify the type of the message, defined as 'type.googleapis.com/full.type.name'. [value](../-any-message/value.md) is the serialized representation of the wrapped message. The [pack](../-any-message/pack.md) and [unpack](../-any-message/unpack.md) methods are available to wrap and unwrap an `Any` message. |
