[wire-runtime](../../index.md) / [com.squareup.wire](../index.md) / [RuntimeEnumAdapter](./index.md)

# RuntimeEnumAdapter

`class RuntimeEnumAdapter<E> : `[`EnumAdapter`](../-enum-adapter/index.md)`<`[`E`](index.md#E)`>`

**Platform and version requirements:** JVM

Converts values of an enum to and from integers using reflection.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `RuntimeEnumAdapter(javaType: `[`Class`](http://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`E`](index.md#E)`>)` |

### Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [fromValue](from-value.md) | `fun fromValue(value: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`E`](index.md#E)`?`<br>Converts an integer to an enum. Returns null if there is no corresponding enum. |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |

### Inherited Functions

| Name | Summary |
|---|---|
| [decode](../-enum-adapter/decode.md)<br>(JVM, js, native) | `open actual fun decode(reader: <ERROR CLASS>): `[`E`](../-enum-adapter/index.md#E) |
| [encode](../-enum-adapter/encode.md)<br>(JVM, js, native) | `open actual fun encode(writer: <ERROR CLASS>, value: `[`E`](../-enum-adapter/index.md#E)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [encodedSize](../-enum-adapter/encoded-size.md)<br>(JVM, js, native) | `open fun encodedSize(value: `[`E`](../-enum-adapter/index.md#E)`): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The size of the non-null data `value`. This does not include the size required for a length-delimited prefix (should the type require one). |
| [redact](../-enum-adapter/redact.md)<br>(JVM, js, native) | `open fun redact(value: `[`E`](../-enum-adapter/index.md#E)`): `[`E`](../-enum-adapter/index.md#E)<br>Returns the redacted form of `value`. |

### Companion Object Functions

| Name | Summary |
|---|---|
| [create](create.md) | `fun <E> create(enumType: `[`Class`](http://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)`<`[`E`](create.md#E)`>): `[`RuntimeEnumAdapter`](./index.md)`<`[`E`](create.md#E)`>` |
