[wire-schema](../index.md) / [com.squareup.wire.schema.internal](./index.md)

## Package com.squareup.wire.schema.internal

### Types

| Name | Summary |
|---|---|
| [DagChecker](-dag-checker/index.md) | `class DagChecker<N>`<br>Checks whether a graph is a directed acyclic graph using [Tarjan's algorithm](https://en.wikipedia.org/wiki/Tarjan%27s_strongly_connected_components_algorithm). |
| [MutableQueue](-mutable-queue/index.md)<br>(JVM, js) | `expect interface MutableQueue<T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> : `[`MutableCollection`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-collection/index.html)`<`[`T`](-mutable-queue/index.md#T)`>` |
| [SchemaEncoder](-schema-encoder/index.md) | `class SchemaEncoder`<br>This class encodes files from a Wire schema using the types in protobuf's `descriptor.proto`. Unfortunately, the two models don't line up directly: |
| [TypeMover](-type-mover/index.md) | `class TypeMover`<br>Refactor a schema by moving a proto type declaration. |

### Extensions for External Classes

| Name | Summary |
|---|---|
| [java.lang.StringBuilder](java.lang.-string-builder/index.md) |  |

### Functions

| Name | Summary |
|---|---|
| [annotationTargetType](annotation-target-type.md)<br>(JVM) | `fun annotationTargetType(extend: <ERROR CLASS>): `[`ElementType`](http://docs.oracle.com/javase/8/docs/api/java/lang/annotation/ElementType.html)`?` |
| [builtInAdapterString](built-in-adapter-string.md)<br>(JVM) | `fun builtInAdapterString(type: <ERROR CLASS>): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`?` |
| [eligibleAsAnnotationMember](eligible-as-annotation-member.md)<br>(JVM) | `fun eligibleAsAnnotationMember(schema: <ERROR CLASS>, field: <ERROR CLASS>): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [javaPackage](java-package.md)<br>(JVM) | `fun javaPackage(protoFile: <ERROR CLASS>): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [optionValueToInt](option-value-to-int.md)<br>(JVM) | `fun optionValueToInt(value: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [optionValueToLong](option-value-to-long.md)<br>(JVM) | `fun optionValueToLong(value: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Long`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [withStubs](with-stubs.md) | `fun `[`Schema`](../com.squareup.wire.schema/-schema/index.md)`.withStubs(typesToStub: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`ProtoType`](../com.squareup.wire.schema/-proto-type/index.md)`>): `[`Schema`](../com.squareup.wire.schema/-schema/index.md)<br>Replace types in this schema which are present in [typesToStub](with-stubs.md#com.squareup.wire.schema.internal$withStubs(com.squareup.wire.schema.Schema, kotlin.collections.Set((com.squareup.wire.schema.ProtoType)))/typesToStub) with empty shells that have no outward references. This has to be done in this module so that we can access the internal constructor to avoid re-linking. |
