//[wire-moshi-adapter](../../../index.md)/[com.squareup.wire](../index.md)/[WireJsonAdapterFactory](index.md)

# WireJsonAdapterFactory

[jvm]\
class [WireJsonAdapterFactory](index.md) : JsonAdapter.Factory

A JsonAdapter.Factory that allows Wire messages to be serialized and deserialized using the Moshi Json library.

Moshi moshi = new Moshi.Builder()\
    .add(new WireJsonAdapterFactory())\
    .build();

The resulting Moshi instance will be able to serialize and deserialize Wire Message types, including extensions. It ignores unknown field values. The JSON encoding is intended to be compatible with the [protobuf-java-format](https://code.google.com/p/protobuf-java-format/) library.

## Constructors

| | |
|---|---|
| [WireJsonAdapterFactory](-wire-json-adapter-factory.md) | [jvm]<br>fun [WireJsonAdapterFactory](-wire-json-adapter-factory.md)() |

## Functions

| Name | Summary |
|---|---|
| [create](create.md) | [jvm]<br>open override fun [create](create.md)(type: [Type](https://docs.oracle.com/javase/8/docs/api/java/lang/reflect/Type.html), annotations: [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[Annotation](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-annotation/index.html)&gt;, moshi: Moshi): JsonAdapter&lt;*&gt;? |
| [plus](plus.md) | [jvm]<br>fun [plus](plus.md)(adapter: ProtoAdapter&lt;*&gt;): [WireJsonAdapterFactory](index.md)<br>Returns a new WireJsonAdapterFactory that can encode the messages for [adapter](plus.md) if they're used with AnyMessage.<br>[jvm]<br>fun [plus](plus.md)(adapters: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;ProtoAdapter&lt;*&gt;&gt;): [WireJsonAdapterFactory](index.md)<br>Returns a new WireJsonAdapterFactory that can encode the messages for [adapters](plus.md) if they're used with AnyMessage. |
