//[wire-compiler](../../../index.md)/[com.squareup.wire](../index.md)/[DryRunFileSystem](index.md)

# DryRunFileSystem

[jvm]\
class [DryRunFileSystem](index.md)(delegate: FileSystem) : ForwardingFileSystem

This FileSystem reads from its delegate but its writing operations do not produce anything.

## Constructors

| | |
|---|---|
| [DryRunFileSystem](-dry-run-file-system.md) | [jvm]<br>fun [DryRunFileSystem](-dry-run-file-system.md)(delegate: FileSystem) |

## Functions

| Name | Summary |
|---|---|
| [appendingSink](index.md#113071512%2FFunctions%2F-1398026261) | [jvm]<br>fun [appendingSink](index.md#113071512%2FFunctions%2F-1398026261)(file: Path): Sink<br>open override fun [appendingSink](appending-sink.md)(file: Path, mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): Sink |
| [atomicMove](index.md#268568284%2FFunctions%2F-1398026261) | [jvm]<br>open override fun [atomicMove](index.md#268568284%2FFunctions%2F-1398026261)(source: Path, target: Path) |
| [canonicalize](index.md#1784218510%2FFunctions%2F-1398026261) | [jvm]<br>open override fun [canonicalize](index.md#1784218510%2FFunctions%2F-1398026261)(path: Path): Path |
| [copy](index.md#419090610%2FFunctions%2F-1398026261) | [jvm]<br>open fun [copy](index.md#419090610%2FFunctions%2F-1398026261)(source: Path, target: Path) |
| [createDirectories](index.md#1601534988%2FFunctions%2F-1398026261) | [jvm]<br>fun [createDirectories](index.md#1601534988%2FFunctions%2F-1398026261)(dir: Path)<br>fun [createDirectories](index.md#1133903352%2FFunctions%2F-1398026261)(dir: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) |
| [createDirectory](index.md#-1674821266%2FFunctions%2F-1398026261) | [jvm]<br>fun [createDirectory](index.md#-1674821266%2FFunctions%2F-1398026261)(dir: Path)<br>open override fun [createDirectory](index.md#1206004057%2FFunctions%2F-1398026261)(dir: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) |
| [createSymlink](index.md#-628889103%2FFunctions%2F-1398026261) | [jvm]<br>open override fun [createSymlink](index.md#-628889103%2FFunctions%2F-1398026261)(source: Path, target: Path) |
| [delete](index.md#-310282218%2FFunctions%2F-1398026261) | [jvm]<br>fun [delete](index.md#-310282218%2FFunctions%2F-1398026261)(path: Path)<br>open override fun [delete](index.md#-1574712245%2FFunctions%2F-1398026261)(path: Path, mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) |
| [deleteRecursively](index.md#-1348423631%2FFunctions%2F-1398026261) | [jvm]<br>fun [deleteRecursively](index.md#-1348423631%2FFunctions%2F-1398026261)(fileOrDirectory: Path)<br>open fun [deleteRecursively](index.md#1932614451%2FFunctions%2F-1398026261)(fileOrDirectory: Path, mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) |
| [exists](index.md#-1094583673%2FFunctions%2F-1398026261) | [jvm]<br>fun [exists](index.md#-1094583673%2FFunctions%2F-1398026261)(path: Path): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [list](index.md#1686757068%2FFunctions%2F-1398026261) | [jvm]<br>open override fun [list](index.md#1686757068%2FFunctions%2F-1398026261)(dir: Path): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Path&gt; |
| [listOrNull](index.md#-1454148490%2FFunctions%2F-1398026261) | [jvm]<br>open override fun [listOrNull](index.md#-1454148490%2FFunctions%2F-1398026261)(dir: Path): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Path&gt;? |
| [listRecursively](index.md#285622878%2FFunctions%2F-1398026261) | [jvm]<br>fun [listRecursively](index.md#285622878%2FFunctions%2F-1398026261)(dir: Path): [Sequence](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.sequences/-sequence/index.html)&lt;Path&gt;<br>open override fun [listRecursively](index.md#-1131926935%2FFunctions%2F-1398026261)(dir: Path, followSymlinks: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Sequence](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.sequences/-sequence/index.html)&lt;Path&gt; |
| [metadata](index.md#-218291494%2FFunctions%2F-1398026261) | [jvm]<br>fun [metadata](index.md#-218291494%2FFunctions%2F-1398026261)(path: Path): FileMetadata |
| [metadataOrNull](index.md#1392114951%2FFunctions%2F-1398026261) | [jvm]<br>open override fun [metadataOrNull](index.md#1392114951%2FFunctions%2F-1398026261)(path: Path): FileMetadata? |
| [onPathParameter](index.md#-714554647%2FFunctions%2F-1398026261) | [jvm]<br>open fun [onPathParameter](index.md#-714554647%2FFunctions%2F-1398026261)(path: Path, functionName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), parameterName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): Path |
| [onPathResult](index.md#-382904844%2FFunctions%2F-1398026261) | [jvm]<br>open fun [onPathResult](index.md#-382904844%2FFunctions%2F-1398026261)(path: Path, functionName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): Path |
| [openReadOnly](index.md#543669114%2FFunctions%2F-1398026261) | [jvm]<br>open override fun [openReadOnly](index.md#543669114%2FFunctions%2F-1398026261)(file: Path): FileHandle |
| [openReadWrite](index.md#1513845788%2FFunctions%2F-1398026261) | [jvm]<br>fun [openReadWrite](index.md#1513845788%2FFunctions%2F-1398026261)(file: Path): FileHandle<br>open override fun [openReadWrite](open-read-write.md)(file: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): FileHandle |
| [read](index.md#-1037056394%2FFunctions%2F-1398026261) | [jvm]<br>inline fun &lt;[T](index.md#-1037056394%2FFunctions%2F-1398026261)&gt; [read](index.md#-1037056394%2FFunctions%2F-1398026261)(file: Path, readerAction: BufferedSource.() -&gt; [T](index.md#-1037056394%2FFunctions%2F-1398026261)): [T](index.md#-1037056394%2FFunctions%2F-1398026261) |
| [sink](index.md#598274238%2FFunctions%2F-1398026261) | [jvm]<br>fun [sink](index.md#598274238%2FFunctions%2F-1398026261)(file: Path): Sink<br>open override fun [sink](sink.md)(file: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): Sink |
| [source](index.md#-332236663%2FFunctions%2F-1398026261) | [jvm]<br>open override fun [source](index.md#-332236663%2FFunctions%2F-1398026261)(file: Path): Source |
| [toString](index.md#-1489847049%2FFunctions%2F-1398026261) | [jvm]<br>open override fun [toString](index.md#-1489847049%2FFunctions%2F-1398026261)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [write](index.md#1005639157%2FFunctions%2F-1398026261) | [jvm]<br>inline fun &lt;[T](index.md#1005639157%2FFunctions%2F-1398026261)&gt; [write](index.md#1005639157%2FFunctions%2F-1398026261)(file: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), writerAction: BufferedSink.() -&gt; [T](index.md#1005639157%2FFunctions%2F-1398026261)): [T](index.md#1005639157%2FFunctions%2F-1398026261) |

## Properties

| Name | Summary |
|---|---|
| [delegate](index.md#2142154750%2FProperties%2F-1398026261) | [jvm]<br>val [delegate](index.md#2142154750%2FProperties%2F-1398026261): FileSystem |
