//[wire-runtime](../../../../../index.md)/[com.squareup.wire](../../../index.md)/[ProtoAdapter](../../index.md)/[Companion](../index.md)/[UnsupportedTypeProtoAdapter](index.md)

# UnsupportedTypeProtoAdapter

[jvm]\
class [UnsupportedTypeProtoAdapter](index.md) : [ProtoAdapter](../../index.md)&lt;[Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)&gt; 

Stub [ProtoAdapter](../../index.md) for Wire types which are typeliased to `java.time` types on the JVM such as [Duration](../../../-duration/index.md) and [Instant](../../../-instant/index.md). This proto adapter is used when the corresponding `java.time` type is missing from the JVM classpath.

## Constructors

| | |
|---|---|
| [UnsupportedTypeProtoAdapter](-unsupported-type-proto-adapter.md) | [jvm]<br>constructor() |

## Properties

| Name | Summary |
|---|---|
| [identity](../../identity.md) | [jvm]<br>actual val [identity](../../identity.md): [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)? |
| [sourceFile](../../source-file.md) | [jvm]<br>actual val [sourceFile](../../source-file.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [syntax](../../syntax.md) | [jvm]<br>actual val [syntax](../../syntax.md): [Syntax](../../../-syntax/index.md) |
| [type](../../type.md) | [jvm]<br>actual val [type](../../type.md): [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;? |
| [typeUrl](../../type-url.md) | [jvm]<br>actual val [typeUrl](../../type-url.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |

## Functions

| Name | Summary |
|---|---|
| [asPacked](../../as-packed.md) | [jvm]<br>actual fun [asPacked](../../as-packed.md)(): [ProtoAdapter](../../index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)&gt;&gt; |
| [asRepeated](../../as-repeated.md) | [jvm]<br>actual fun [asRepeated](../../as-repeated.md)(): [ProtoAdapter](../../index.md)&lt;[List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)&gt;&gt; |
| [decode](../../decode.md) | [jvm]<br>fun [decode](../../decode.md)(stream: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)): [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)<br>actual fun [decode](../../decode.md)(bytes: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)<br>actual fun [decode](../../decode.md)(source: BufferedSource): [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)<br>actual fun [decode](../../decode.md)(bytes: ByteString): [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)<br>open override fun [decode](decode.md)(reader: [ProtoReader](../../../-proto-reader/index.md)): [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) |
| [decode](../../../decode.md) | [darwin]<br>@[ExperimentalUnsignedTypes](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-experimental-unsigned-types/index.html)<br>fun &lt;[E](../../../decode.md)&gt; [ProtoAdapter](../../index.md)&lt;[E](../../../decode.md)&gt;.[decode](../../../decode.md)(data: NSData): [E](../../../decode.md)<br>Read an encoded message from `data`. |
| [encode](index.md#-451862368%2FFunctions%2F1823866683) | [jvm]<br>actual fun [encode](index.md#-451862368%2FFunctions%2F1823866683)(value: [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>fun [encode](index.md#-1563320484%2FFunctions%2F1823866683)(stream: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), value: [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html))<br>actual fun [encode](index.md#1486071995%2FFunctions%2F1823866683)(sink: BufferedSink, value: [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html))<br>open override fun [encode](encode.md)(writer: [ProtoWriter](../../../-proto-writer/index.md), value: [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)): [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)<br>open override fun [encode](encode.md)(writer: [ReverseProtoWriter](../../../-reverse-proto-writer/index.md), value: [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)): [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) |
| [encodeByteString](index.md#626486119%2FFunctions%2F1823866683) | [jvm]<br>actual fun [encodeByteString](index.md#626486119%2FFunctions%2F1823866683)(value: [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)): ByteString |
| [encodedSize](encoded-size.md) | [jvm]<br>open override fun [encodedSize](encoded-size.md)(value: [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)): [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) |
| [encodedSizeWithTag](index.md#-832141005%2FFunctions%2F1823866683) | [jvm]<br>actual open fun [encodedSizeWithTag](index.md#-832141005%2FFunctions%2F1823866683)(tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [encodeWithTag](index.md#-754100352%2FFunctions%2F1823866683) | [jvm]<br>actual open fun [encodeWithTag](index.md#-754100352%2FFunctions%2F1823866683)(writer: [ProtoWriter](../../../-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)?)<br>actual open fun [encodeWithTag](index.md#-2018553612%2FFunctions%2F1823866683)(writer: [ReverseProtoWriter](../../../-reverse-proto-writer/index.md), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), value: [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)?) |
| [redact](redact.md) | [jvm]<br>open override fun [redact](redact.md)(value: [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)): [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) |
| [toString](index.md#-1033487030%2FFunctions%2F1823866683) | [jvm]<br>actual open fun [toString](index.md#-1033487030%2FFunctions%2F1823866683)(value: [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [tryDecode](index.md#352901731%2FFunctions%2F1823866683) | [jvm]<br>actual fun [tryDecode](index.md#352901731%2FFunctions%2F1823866683)(reader: [ProtoReader](../../../-proto-reader/index.md), destination: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)&gt;) |
