//[wire-schema](../../index.md)/[com.squareup.wire.schema](index.md)

# Package com.squareup.wire.schema

## Types

| Name | Summary |
|---|---|
| [ClaimedDefinitions](-claimed-definitions/index.md) | [jvm]<br>class [ClaimedDefinitions](-claimed-definitions/index.md) |
| [CoreLoader](-core-loader/index.md) | [common, js]<br>[common]<br>object [CoreLoader](-core-loader/index.md) : [Loader](-loader/index.md)<br>[js]<br>object [CoreLoader](-core-loader/index.md) : Loader<br>[jvm]<br>object [CoreLoader](-core-loader/index.md) : Loader<br>A loader that can only load built-in .proto files: |
| [EmittingRules](-emitting-rules/index.md) | [jvm]<br>class [EmittingRules](-emitting-rules/index.md)<br>A set of rules that describes which types to generate. |
| [EnclosingType](-enclosing-type/index.md) | [common]<br>data class [EnclosingType](-enclosing-type/index.md)(location: [Location](-location/index.md), type: [ProtoType](-proto-type/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), nestedTypes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Type](-type/index.md)&gt;, syntax: Syntax) : [Type](-type/index.md)<br>An empty type which only holds nested types. |
| [EnumConstant](-enum-constant/index.md) | [common]<br>data class [EnumConstant](-enum-constant/index.md)(location: [Location](-location/index.md), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [Options](-options/index.md)) |
| [EnumType](-enum-type/index.md) | [common]<br>data class [EnumType](-enum-type/index.md)(type: [ProtoType](-proto-type/index.md), location: [Location](-location/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), constants: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[EnumConstant](-enum-constant/index.md)&gt;, reserveds: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Reserved](-reserved/index.md)&gt;, options: [Options](-options/index.md), syntax: Syntax) : [Type](-type/index.md) |
| [ErrorCollector](-error-collector/index.md) | [common]<br>class [ErrorCollector](-error-collector/index.md)<br>Collects errors to be reported as a batch. Errors include both a detail message plus context of where they occurred within the schema. |
| [Extend](-extend/index.md) | [common]<br>data class [Extend](-extend/index.md)(location: [Location](-location/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), fields: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Field](-field/index.md)&gt;) |
| [Extensions](-extensions/index.md) | [common]<br>data class [Extensions](-extensions/index.md)(location: [Location](-location/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), values: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;) |
| [Field](-field/index.md) | [common]<br>data class [Field](-field/index.md)(packageName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, location: [Location](-location/index.md), label: [Field.Label](-field/-label/index.md)?, name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), default: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, elementType: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [Options](-options/index.md), isExtension: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), isOneOf: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), declaredJsonName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) |
| [LinkedOptionEntry](-linked-option-entry/index.md) | [common]<br>data class [LinkedOptionEntry](-linked-option-entry/index.md)(optionElement: [OptionElement](../com.squareup.wire.schema.internal.parser/-option-element/index.md), protoMember: [ProtoMember](-proto-member/index.md), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?) |
| [Linker](-linker/index.md) | [common]<br>class [Linker](-linker/index.md)<br>Links local field types and option types to the corresponding declarations. |
| [Loader](-loader/index.md) | [common]<br>interface [Loader](-loader/index.md)<br>Loads other files as needed by their import path. |
| [Location](-location/index.md) | [common]<br>data class [Location](-location/index.md)(base: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), line: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), column: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html))<br>Locates a .proto file, or a position within a .proto file, on the file system. This includes a base directory or a .jar file, and a path relative to that base. |
| [MarkSet](-mark-set/index.md) | [common]<br>class [MarkSet](-mark-set/index.md)(pruningRules: [PruningRules](-pruning-rules/index.md))<br>A mark set is used in three phases: |
| [MessageType](-message-type/index.md) | [common]<br>data class [MessageType](-message-type/index.md)(type: [ProtoType](-proto-type/index.md), location: [Location](-location/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), declaredFields: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Field](-field/index.md)&gt;, extensionFields: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[Field](-field/index.md)&gt;, oneOfs: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[OneOf](-one-of/index.md)&gt;, nestedTypes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Type](-type/index.md)&gt;, extensionsList: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Extensions](-extensions/index.md)&gt;, reserveds: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Reserved](-reserved/index.md)&gt;, options: [Options](-options/index.md), syntax: Syntax) : [Type](-type/index.md) |
| [Multimap](-multimap/index.md) | [common, js, jvm]<br>[common, js]<br>interface [Multimap](-multimap/index.md)&lt;[K](-multimap/index.md), [V](-multimap/index.md)&gt;<br>[jvm]<br>typealias [Multimap](-multimap/index.md) = Multimap&lt;[K](-multimap/index.md), [V](-multimap/index.md)&gt; |
| [OneOf](-one-of/index.md) | [common]<br>data class [OneOf](-one-of/index.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), fields: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Field](-field/index.md)&gt;) |
| [Options](-options/index.md) | [common]<br>class [Options](-options/index.md)(optionType: [ProtoType](-proto-type/index.md), optionElements: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[OptionElement](../com.squareup.wire.schema.internal.parser/-option-element/index.md)&gt;)<br>A set of options declared on a message declaration, field declaration, enum declaration, enum constant declaration, service declaration, RPC method declaration, or proto file declaration. Options values may be arbitrary protocol buffer messages, but must be valid protocol buffer messages. |
| [ProtoFile](-proto-file/index.md) | [common]<br>data class [ProtoFile](-proto-file/index.md)(location: [Location](-location/index.md), imports: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, publicImports: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, packageName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, types: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Type](-type/index.md)&gt;, services: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Service](-service/index.md)&gt;, extendList: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Extend](-extend/index.md)&gt;, options: [Options](-options/index.md), syntax: Syntax?) |
| [ProtoMember](-proto-member/index.md) | [common]<br>class [ProtoMember](-proto-member/index.md)<br>Identifies a field, enum or RPC on a declaring type. Members are encoded as strings containing a type name, a hash, and a member name, like squareup.dinosaurs.Dinosaur#length_meters. |
| [ProtoType](-proto-type/index.md) | [common]<br>class [ProtoType](-proto-type/index.md)<br>Names a protocol buffer message, enumerated type, service, map, or a scalar. This class models a fully-qualified name using the protocol buffer package. |
| [Pruner](-pruner/index.md) | [common]<br>class [Pruner](-pruner/index.md)(schema: [Schema](-schema/index.md), pruningRules: [PruningRules](-pruning-rules/index.md))<br>Creates a new schema that contains only the types selected by the pruning rules, including their transitive dependencies. |
| [PruningRules](-pruning-rules/index.md) | [common]<br>class [PruningRules](-pruning-rules/index.md)<br>A set of rules that describes which types and members to retain and which to remove. |
| [Reserved](-reserved/index.md) | [common]<br>data class [Reserved](-reserved/index.md)(location: [Location](-location/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), values: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;) |
| [Rpc](-rpc/index.md) | [common]<br>data class [Rpc](-rpc/index.md)(location: [Location](-location/index.md), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), requestTypeElement: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), responseTypeElement: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), requestStreaming: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), responseStreaming: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), options: [Options](-options/index.md)) |
| [Schema](-schema/index.md) | [common]<br>class [Schema](-schema/index.md)<br>A collection of .proto files that describe a set of messages. A schema is *linked*: each field's type name is resolved to the corresponding type definition. |
| [SchemaException](-schema-exception/index.md) | [common]<br>class [SchemaException](-schema-exception/index.md)(errors: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;) : [RuntimeException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-runtime-exception/index.html) |
| [Service](-service/index.md) | [common]<br>data class [Service](-service/index.md)(type: [ProtoType](-proto-type/index.md), location: [Location](-location/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), rpcs: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Rpc](-rpc/index.md)&gt;, options: [Options](-options/index.md)) |
| [SyntaxRules](-syntax-rules/index.md) | [common]<br>interface [SyntaxRules](-syntax-rules/index.md)<br>A set of rules which defines schema requirements for a specific Syntax. |
| [Type](-type/index.md) | [common]<br>abstract class [Type](-type/index.md) |
