//[wire-schema](../../index.md)/[com.squareup.wire.schema](index.md)

# Package com.squareup.wire.schema

## Types

| Name | Summary |
|---|---|
| [AdapterConstant](-adapter-constant/index.md) | [jvm]<br>data class [AdapterConstant](-adapter-constant/index.md)(javaClassName: ClassName, kotlinClassName: ClassName, memberName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>A constant field that identifies a ProtoAdapter. This should be a string like like com.squareup.dinosaurs.Dinosaur#ADAPTER with a fully qualified class name, a #, and a field name. |
| [ClaimedDefinitions](-claimed-definitions/index.md) | [common]<br>class [ClaimedDefinitions](-claimed-definitions/index.md)<br>[ClaimedDefinitions](-claimed-definitions/index.md) tracks handled objects: [Type](-type/index.md)s, [Service](-service/index.md)s, and [Field](-field/index.md)s. A [SchemaHandler](-schema-handler/index.md) is to first check if an object has already been claimed; if yes, it is not to handle it. Otherwise, the [SchemaHandler](-schema-handler/index.md) is to handle the object and [claim](-claimed-definitions/claim.md) it. It is an error for a [SchemaHandler](-schema-handler/index.md) to handle an object which has already been claimed. |
| [ClaimedPaths](-claimed-paths/index.md) | [common]<br>class [ClaimedPaths](-claimed-paths/index.md)<br>[ClaimedPaths](-claimed-paths/index.md) tracks generated files' Paths. [Schema handlers](-schema-handler/index.md) who generate files are to [claim](-claimed-paths/claim.md) each generated file's path. It is an error to generate different [Type](-type/index.md)s or [Service](-service/index.md)s to the same file and [ClaimedPaths](-claimed-paths/index.md) will throw when generation conflicts happen. |
| [CoreLoader](-core-loader/index.md) | [common, js]<br>[common]<br>object [CoreLoader](-core-loader/index.md) : [Loader](-loader/index.md)<br>[js]<br>object [CoreLoader](-core-loader/index.md) : Loader<br>[jvm]<br>object [CoreLoader](-core-loader/index.md) : Loader<br>A loader that can only load built-in .proto files: |
| [EmittingRules](-emitting-rules/index.md) | [common]<br>class [EmittingRules](-emitting-rules/index.md)<br>A set of rules that describes which types to generate. |
| [EnclosingType](-enclosing-type/index.md) | [common]<br>data class [EnclosingType](-enclosing-type/index.md)(location: [Location](-location/index.md), type: [ProtoType](-proto-type/index.md), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), nestedTypes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Type](-type/index.md)&gt;, nestedExtendList: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Extend](-extend/index.md)&gt;, syntax: Syntax) : [Type](-type/index.md)<br>An empty type which only holds nested types. |
| [EnumConstant](-enum-constant/index.md) | [common]<br>data class [EnumConstant](-enum-constant/index.md)(location: [Location](-location/index.md), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [Options](-options/index.md)) |
| [EnumType](-enum-type/index.md) | [common]<br>data class [EnumType](-enum-type/index.md)(type: [ProtoType](-proto-type/index.md), location: [Location](-location/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), constants: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[EnumConstant](-enum-constant/index.md)&gt;, reserveds: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Reserved](-reserved/index.md)&gt;, options: [Options](-options/index.md), syntax: Syntax) : [Type](-type/index.md) |
| [ErrorCollector](-error-collector/index.md) | [common]<br>class [ErrorCollector](-error-collector/index.md)<br>Collects errors to be reported as a batch. Errors include both a detail message plus context of where they occurred within the schema. |
| [Extend](-extend/index.md) | [common]<br>data class [Extend](-extend/index.md)(location: [Location](-location/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), fields: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Field](-field/index.md)&gt;) |
| [Extensions](-extensions/index.md) | [common]<br>data class [Extensions](-extensions/index.md)(location: [Location](-location/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), values: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;) |
| [Field](-field/index.md) | [common]<br>data class [Field](-field/index.md)(namespaces: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, location: [Location](-location/index.md), label: [Field.Label](-field/-label/index.md)?, name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), default: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, elementType: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [Options](-options/index.md), isExtension: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), isOneOf: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), declaredJsonName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) |
| [LinkedOptionEntry](-linked-option-entry/index.md) | [common]<br>data class [LinkedOptionEntry](-linked-option-entry/index.md)(optionElement: [OptionElement](../com.squareup.wire.schema.internal.parser/-option-element/index.md), protoMember: [ProtoMember](-proto-member/index.md), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?) |
| [Linker](-linker/index.md) | [common]<br>class [Linker](-linker/index.md)<br>Links local field types and option types to the corresponding declarations. |
| [Loader](-loader/index.md) | [common]<br>interface [Loader](-loader/index.md)<br>Loads other files as needed by their import path. |
| [Location](-location/index.md) | [common]<br>data class [Location](-location/index.md)(base: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), line: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), column: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html))<br>Locates a .proto file, or a position within a .proto file, on the file system. This includes a base directory or a .jar file, and a path relative to that base. |
| [MarkSet](-mark-set/index.md) | [common]<br>class [MarkSet](-mark-set/index.md)(pruningRules: [PruningRules](-pruning-rules/index.md))<br>A mark set is used in three phases: |
| [MessageType](-message-type/index.md) | [common]<br>data class [MessageType](-message-type/index.md)(type: [ProtoType](-proto-type/index.md), location: [Location](-location/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), declaredFields: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Field](-field/index.md)&gt;, extensionFields: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[Field](-field/index.md)&gt;, oneOfs: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[OneOf](-one-of/index.md)&gt;, nestedTypes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Type](-type/index.md)&gt;, nestedExtendList: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Extend](-extend/index.md)&gt;, extensionsList: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Extensions](-extensions/index.md)&gt;, reserveds: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Reserved](-reserved/index.md)&gt;, options: [Options](-options/index.md), syntax: Syntax) : [Type](-type/index.md) |
| [Multimap](-multimap/index.md) | [common, js, jvm]<br>[common, js]<br>interface [Multimap](-multimap/index.md)&lt;[K](-multimap/index.md), [V](-multimap/index.md)&gt;<br>[jvm]<br>typealias [Multimap](-multimap/index.md) = Multimap&lt;[K](-multimap/index.md), [V](-multimap/index.md)&gt; |
| [OneOf](-one-of/index.md) | [common]<br>data class [OneOf](-one-of/index.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), fields: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Field](-field/index.md)&gt;) |
| [Options](-options/index.md) | [common]<br>class [Options](-options/index.md)(optionType: [ProtoType](-proto-type/index.md), optionElements: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[OptionElement](../com.squareup.wire.schema.internal.parser/-option-element/index.md)&gt;)<br>A set of options declared on a message declaration, field declaration, enum declaration, enum constant declaration, service declaration, RPC method declaration, or proto file declaration. Options values may be arbitrary protocol buffer messages, but must be valid protocol buffer messages. |
| [Profile](-profile/index.md) | [common, js]<br>[common]<br>class [Profile](-profile/index.md)(profileFiles: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ProfileFileElement](../com.squareup.wire.schema.internal/-profile-file-element/index.md)&gt;)<br>[js]<br>class [Profile](-profile/index.md)(profileFiles: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;ProfileFileElement&gt;)<br>[jvm]<br>class [Profile](-profile/index.md)(profileFiles: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;ProfileFileElement&gt;)<br>Describes how to map .proto to .java. A single repository of .proto files may have multiple profiles; for example a project may target both Android and Java. |
| [ProfileLoader](-profile-loader/index.md) | [common]<br>interface [ProfileLoader](-profile-loader/index.md) |
| [ProtoFile](-proto-file/index.md) | [common]<br>data class [ProtoFile](-proto-file/index.md)(location: [Location](-location/index.md), imports: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, publicImports: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, packageName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, types: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Type](-type/index.md)&gt;, services: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Service](-service/index.md)&gt;, extendList: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Extend](-extend/index.md)&gt;, options: [Options](-options/index.md), syntax: Syntax?) |
| [ProtoMember](-proto-member/index.md) | [common]<br>class [ProtoMember](-proto-member/index.md)<br>Identifies a field, enum or RPC on a declaring type. Members are encoded as strings containing a type name, a hash, and a member name, like squareup.dinosaurs.Dinosaur#length_meters. |
| [ProtoType](-proto-type/index.md) | [common]<br>class [ProtoType](-proto-type/index.md)<br>Names a protocol buffer message, enumerated type, service, map, or a scalar. This class models a fully-qualified name using the protocol buffer package. |
| [Pruner](-pruner/index.md) | [common]<br>class [Pruner](-pruner/index.md)(schema: [Schema](-schema/index.md), pruningRules: [PruningRules](-pruning-rules/index.md))<br>Creates a new schema that contains only the types selected by the pruning rules, including their transitive dependencies. |
| [PruningRules](-pruning-rules/index.md) | [common]<br>class [PruningRules](-pruning-rules/index.md)<br>A set of rules that describes which types and members to retain and which to remove. |
| [Reserved](-reserved/index.md) | [common]<br>data class [Reserved](-reserved/index.md)(location: [Location](-location/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), values: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;) |
| [Rpc](-rpc/index.md) | [common]<br>data class [Rpc](-rpc/index.md)(location: [Location](-location/index.md), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), requestTypeElement: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), responseTypeElement: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), requestStreaming: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), responseStreaming: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), options: [Options](-options/index.md)) |
| [Schema](-schema/index.md) | [common]<br>class [Schema](-schema/index.md)<br>A collection of .proto files that describe a set of messages. A schema is *linked*: each field's type name is resolved to the corresponding type definition. |
| [SchemaException](-schema-exception/index.md) | [common]<br>class [SchemaException](-schema-exception/index.md)(errors: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;) : [RuntimeException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-runtime-exception/index.html) |
| [SchemaHandler](-schema-handler/index.md) | [common]<br>abstract class [SchemaHandler](-schema-handler/index.md)<br>A [SchemaHandler](-schema-handler/handle.md)s [Schema](-schema/index.md)! |
| [SchemaLoader](-schema-loader/index.md) | [common]<br>class [SchemaLoader](-schema-loader/index.md) : [Loader](-loader/index.md), [ProfileLoader](-profile-loader/index.md)<br>Load proto files and their transitive dependencies and parse them. Keep track of which files were loaded from where so that we can use that information later when deciding what to generate.<br>[js, jvm]<br>[js, jvm]<br>class [SchemaLoader](-schema-loader/index.md) : Loader, ProfileLoader |
| [Service](-service/index.md) | [common]<br>data class [Service](-service/index.md)(type: [ProtoType](-proto-type/index.md), location: [Location](-location/index.md), documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), rpcs: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Rpc](-rpc/index.md)&gt;, options: [Options](-options/index.md)) |
| [SyntaxRules](-syntax-rules/index.md) | [common]<br>interface [SyntaxRules](-syntax-rules/index.md)<br>A set of rules which defines schema requirements for a specific Syntax. |
| [Type](-type/index.md) | [common]<br>sealed class [Type](-type/index.md) |

## Functions

| Name | Summary |
|---|---|
| [isWireRuntimeProto](is-wire-runtime-proto.md) | [common]<br>fun [isWireRuntimeProto](is-wire-runtime-proto.md)(location: [Location](-location/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[common]<br>fun [isWireRuntimeProto](is-wire-runtime-proto.md)(path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [path](is-wire-runtime-proto.md) is bundled in the wire runtime. |

## Properties

| Name | Summary |
|---|---|
| [WIRE_RUNTIME_JAR](-w-i-r-e_-r-u-n-t-i-m-e_-j-a-r.md) | [common]<br>const val [WIRE_RUNTIME_JAR](-w-i-r-e_-r-u-n-t-i-m-e_-j-a-r.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>A special base directory used for Wire's built-in .proto files. |
