//[wire-schema](../../index.md)/[com.squareup.wire.schema.internal](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [DagChecker](-dag-checker/index.md) | [common]<br>class [DagChecker](-dag-checker/index.md)&lt;[N](-dag-checker/index.md)&gt;(nodes: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[N](-dag-checker/index.md)&gt;, edges: ([N](-dag-checker/index.md)) -&gt; [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[N](-dag-checker/index.md)&gt;)<br>Checks whether a graph is a directed acyclic graph using [Tarjan's algorithm](https://en.wikipedia.org/wiki/Tarjan%27s_strongly_connected_components_algorithm). |
| [MutableQueue](-mutable-queue/index.md) | [common, js, native, jvm]<br>[common]<br>expect interface [MutableQueue](-mutable-queue/index.md)&lt;[T](-mutable-queue/index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; : [MutableCollection](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-collection/index.html)&lt;[T](-mutable-queue/index.md)&gt; <br>[js, native]<br>actual interface [MutableQueue](-mutable-queue/index.md)&lt;[T](-mutable-queue/index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; : [MutableCollection](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-collection/index.html)&lt;[T](-mutable-queue/index.md)&gt; <br>[jvm]<br>actual typealias [MutableQueue](-mutable-queue/index.md)&lt;[T](-mutable-queue/index.md)&gt; = [Queue](https://docs.oracle.com/javase/8/docs/api/java/util/Queue.html)&lt;[T](-mutable-queue/index.md)&gt; |
| [NameFactory](-name-factory/index.md) | [jvm]<br>interface [NameFactory](-name-factory/index.md)&lt;[T](-name-factory/index.md)&gt;<br>NameFactory is an abstraction for creating language-specific (Java vs Kotlin) type names. |
| [ProfileFileElement](-profile-file-element/index.md) | [common]<br>data class [ProfileFileElement](-profile-file-element/index.md)(val location: [Location](../com.squareup.wire.schema/-location/index.md), val packageName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null, val imports: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; = emptyList(), val typeConfigs: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[TypeConfigElement](-type-config-element/index.md)&gt; = emptyList())<br>A single `.wire` file. This file is structured similarly to a `.proto` file, but with different elements. |
| [ProfileParser](-profile-parser/index.md) | [common]<br>class [ProfileParser](-profile-parser/index.md)(location: [Location](../com.squareup.wire.schema/-location/index.md), data: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>Parses `.wire` files. |
| [SchemaEncoder](-schema-encoder/index.md) | [common]<br>class [SchemaEncoder](-schema-encoder/index.md)(schema: [Schema](../com.squareup.wire.schema/-schema/index.md))<br>This class encodes files from a Wire schema using the types in protobuf's `descriptor.proto`. Unfortunately, the two models don't line up directly: |
| [TypeConfigElement](-type-config-element/index.md) | [common]<br>data class [TypeConfigElement](-type-config-element/index.md)(val location: [Location](../com.squareup.wire.schema/-location/index.md), val type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null, val documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;&quot;, val with: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[OptionElement](../com.squareup.wire.schema.internal.parser/-option-element/index.md)&gt; = emptyList(), val target: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null, val adapter: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null)<br>Configures how Wire will generate code for a specific type. This configuration belongs in a `build.wire` file that is in the same directory as the configured type. |
| [TypeMover](-type-mover/index.md) | [common]<br>class [TypeMover](-type-mover/index.md)(oldSchema: [Schema](../com.squareup.wire.schema/-schema/index.md), moves: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[TypeMover.Move](-type-mover/-move/index.md)&gt;)<br>Refactor a schema by moving a proto type declaration. |

## Functions

| Name | Summary |
|---|---|
| [annotationName](annotation-name.md) | [jvm]<br>fun &lt;[T](annotation-name.md)&gt; [annotationName](annotation-name.md)(protoFile: [ProtoFile](../com.squareup.wire.schema/-proto-file/index.md), extension: [Field](../com.squareup.wire.schema/-field/index.md), factory: [NameFactory](-name-factory/index.md)&lt;[T](annotation-name.md)&gt;): [T](annotation-name.md) |
| [annotationTargetType](annotation-target-type.md) | [jvm]<br>fun [annotationTargetType](annotation-target-type.md)(extend: [Extend](../com.squareup.wire.schema/-extend/index.md)): [ElementType](https://docs.oracle.com/javase/8/docs/api/java/lang/annotation/ElementType.html)? |
| [appendDocumentation](append-documentation.md) | [common]<br>fun [StringBuilder](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.text/-string-builder/index.html).[appendDocumentation](append-documentation.md)(documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) |
| [appendIndented](append-indented.md) | [common]<br>fun [StringBuilder](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.text/-string-builder/index.html).[appendIndented](append-indented.md)(value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) |
| [builtInAdapterString](built-in-adapter-string.md) | [jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [builtInAdapterString](built-in-adapter-string.md)(type: [ProtoType](../com.squareup.wire.schema/-proto-type/index.md), useArray: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [eligibleAsAnnotationMember](eligible-as-annotation-member.md) | [jvm]<br>fun [eligibleAsAnnotationMember](eligible-as-annotation-member.md)(schema: [Schema](../com.squareup.wire.schema/-schema/index.md), field: [Field](../com.squareup.wire.schema/-field/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hasEponymousType](has-eponymous-type.md) | [jvm]<br>fun [hasEponymousType](has-eponymous-type.md)(schema: [Schema](../com.squareup.wire.schema/-schema/index.md), field: [Field](../com.squareup.wire.schema/-field/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [javaPackage](java-package.md) | [jvm]<br>fun [javaPackage](java-package.md)(protoFile: [ProtoFile](../com.squareup.wire.schema/-proto-file/index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [legacyQualifiedFieldName](legacy-qualified-field-name.md) | [jvm]<br>fun [legacyQualifiedFieldName](legacy-qualified-field-name.md)(field: [Field](../com.squareup.wire.schema/-field/index.md)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [optionValueToInt](option-value-to-int.md) | [jvm]<br>fun [optionValueToInt](option-value-to-int.md)(value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [optionValueToLong](option-value-to-long.md) | [jvm]<br>fun [optionValueToLong](option-value-to-long.md)(value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [withStubs](with-stubs.md) | [common]<br>fun [Schema](../com.squareup.wire.schema/-schema/index.md).[withStubs](with-stubs.md)(typesToStub: [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[ProtoType](../com.squareup.wire.schema/-proto-type/index.md)&gt;): [Schema](../com.squareup.wire.schema/-schema/index.md)<br>Replace types in this schema which are present in [typesToStub](with-stubs.md) with empty shells that have no outward references. This has to be done in this module so that we can access the internal constructor to avoid re-linking. |
| [withUnixSlashes](with-unix-slashes.md) | [common]<br>fun Path.[withUnixSlashes](with-unix-slashes.md)(): Path |
