//[wire-schema](../../../index.md)/[com.squareup.wire.schema](../index.md)/[EventListener](index.md)

# EventListener

[common]\
abstract class [EventListener](index.md)

Listener for metrics events. Extend this class to monitor WireRun and all [schema handlers](../-schema-handler/index.md) involved in the Protobuf schema manipulation.

The events' order is as follows:

- 
   runStart
- 
   loadSchemaStart
- 
   loadSchemaSuccess
- 
   treeShakeStart
- 
   treeShakeEnd
- 
   moveTypesStart
- 
   moveTypesEnd
- 
   schemaHandlersStart // Looping over all handlers.
- - 
      schemaHandlerStart
   - 
      schemaHandlerEnd
- 
   schemaHandlersEnd
- 
   runSuccess / runFailed

## Constructors

| | |
|---|---|
| [EventListener](-event-listener.md) | [common]<br>constructor() |

## Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | [common]<br>fun interface [Factory](-factory/index.md) : Serializable |

## Functions

| Name | Summary |
|---|---|
| [loadSchemaStart](load-schema-start.md) | [common]<br>open fun [loadSchemaStart](load-schema-start.md)()<br>Invoked prior to loading the Protobuf schema. this includes parsing `.proto` files, and resolving all referenced types. |
| [loadSchemaSuccess](load-schema-success.md) | [common]<br>open fun [loadSchemaSuccess](load-schema-success.md)(schema: [Schema](../-schema/index.md))<br>Invoked after having loaded the Protobuf [schema](load-schema-success.md). this includes parsing `.proto` files, and resolving all referenced types. |
| [moveTypesEnd](move-types-end.md) | [common]<br>open fun [moveTypesEnd](move-types-end.md)(refactoredSchema: [Schema](../-schema/index.md), moves: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[TypeMover.Move](../../com.squareup.wire.schema.internal/-type-mover/-move/index.md)&gt;)<br>Invoked after having refactored the Protobuf schema by applying the [moves](move-types-end.md). |
| [moveTypesStart](move-types-start.md) | [common]<br>open fun [moveTypesStart](move-types-start.md)(schema: [Schema](../-schema/index.md), moves: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[TypeMover.Move](../../com.squareup.wire.schema.internal/-type-mover/-move/index.md)&gt;)<br>Invoked prior to refactoring the Protobuf [schema](move-types-start.md) by applying the [moves](move-types-start.md). |
| [runFailed](run-failed.md) | [common]<br>open fun [runFailed](run-failed.md)(errors: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;) |
| [runStart](run-start.md) | [common]<br>open fun [runStart](run-start.md)(wireRun: [WireRun](../-wire-run/index.md))<br>Invoked prior to Wire starting. |
| [runSuccess](run-success.md) | [common]<br>open fun [runSuccess](run-success.md)(wireRun: [WireRun](../-wire-run/index.md))<br>Invoked after Wire has executed all operations. |
| [schemaHandlerEnd](schema-handler-end.md) | [common]<br>open fun [schemaHandlerEnd](schema-handler-end.md)(schemaHandler: [SchemaHandler](../-schema-handler/index.md), emittingRules: [EmittingRules](../-emitting-rules/index.md))<br>Invoked after a [schema handler](../-schema-handler/index.md) has finished. |
| [schemaHandlersEnd](schema-handlers-end.md) | [common]<br>open fun [schemaHandlersEnd](schema-handlers-end.md)()<br>Invoked after having executed all [schema handler](../-schema-handler/index.md). |
| [schemaHandlersStart](schema-handlers-start.md) | [common]<br>open fun [schemaHandlersStart](schema-handlers-start.md)()<br>Invoked prior to executing all [schema handler](../-schema-handler/index.md). |
| [schemaHandlerStart](schema-handler-start.md) | [common]<br>open fun [schemaHandlerStart](schema-handler-start.md)(schemaHandler: [SchemaHandler](../-schema-handler/index.md), emittingRules: [EmittingRules](../-emitting-rules/index.md))<br>Invoked prior a [schema handler](../-schema-handler/index.md) starting. |
| [treeShakeEnd](tree-shake-end.md) | [common]<br>open fun [treeShakeEnd](tree-shake-end.md)(refactoredSchema: [Schema](../-schema/index.md), pruningRules: [PruningRules](../-pruning-rules/index.md))<br>Invoked after having refactored the Protobuf schema by tree-shaking it using the [pruning rules](../-pruning-rules/index.md). |
| [treeShakeStart](tree-shake-start.md) | [common]<br>open fun [treeShakeStart](tree-shake-start.md)(schema: [Schema](../-schema/index.md), pruningRules: [PruningRules](../-pruning-rules/index.md))<br>Invoked prior to refactoring the Protobuf [schema](tree-shake-start.md) by tree-shaking it using the [pruning rules](../-pruning-rules/index.md). |
