//[wire-schema](../../../index.md)/[com.squareup.wire.schema](../index.md)/[SchemaLoader](index.md)

# SchemaLoader

[common]\
expect class [SchemaLoader](index.md)(fileSystem: FileSystem) : [Loader](../-loader/index.md), [ProfileLoader](../-profile-loader/index.md)

Load proto files and their transitive dependencies and parse them. Keep track of which files were loaded from where so that we can use that information later when deciding what to generate.

[js, jvm, native]\
actual class [SchemaLoader](index.md)(fileSystem: FileSystem) : [Loader](../-loader/index.md), [ProfileLoader](../-profile-loader/index.md)

## Constructors

| | |
|---|---|
| [SchemaLoader](-schema-loader.md) | [jvm]<br>constructor(fileSystem: [FileSystem](https://docs.oracle.com/javase/8/docs/api/java/nio/file/FileSystem.html))actual constructor(fileSystem: FileSystem)<br>[common]<br>expect constructor(fileSystem: FileSystem)<br>[js, native]<br>actual constructor(fileSystem: FileSystem) |

## Properties

| Name | Summary |
|---|---|
| [loadExhaustively](load-exhaustively.md) | [common, js, jvm, native]<br>[common]<br>expect var [loadExhaustively](load-exhaustively.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[js, jvm, native]<br>actual var [loadExhaustively](load-exhaustively.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>If true, the schema loader will load the whole graph, including files and types not used by anything in the source path. |
| [permitPackageCycles](permit-package-cycles.md) | [common, js, jvm, native]<br>[common]<br>expect var [permitPackageCycles](permit-package-cycles.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[js, jvm, native]<br>actual var [permitPackageCycles](permit-package-cycles.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Strict by default. Note that golang cannot build protos with package cycles. |
| [sourcePathFiles](source-path-files.md) | [common, js, jvm, native]<br>[common]<br>expect val [sourcePathFiles](source-path-files.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ProtoFile](../-proto-file/index.md)&gt;<br>[js, jvm, native]<br>actual val [sourcePathFiles](source-path-files.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ProtoFile](../-proto-file/index.md)&gt;<br>Subset of the schema that was loaded from the source path. |

## Functions

| Name | Summary |
|---|---|
| [initRoots](init-roots.md) | [common, js, jvm, native]<br>[common]<br>expect fun [initRoots](init-roots.md)(sourcePath: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Location](../-location/index.md)&gt;, protoPath: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Location](../-location/index.md)&gt; = listOf())<br>[js, jvm, native]<br>actual fun [initRoots](init-roots.md)(sourcePath: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Location](../-location/index.md)&gt;, protoPath: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Location](../-location/index.md)&gt;)<br>Initialize the [WireRun.sourcePath](../-wire-run/source-path.md) and [WireRun.protoPath](../-wire-run/proto-path.md) from which files are loaded. |
| [load](../-loader/load.md) | [common, js, jvm, native]<br>[common]<br>abstract fun [load](../-loader/load.md)(path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [ProtoFile](../-proto-file/index.md)<br>[js]<br>open override fun [load]([js]load.md)(path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [ProtoFile](../-proto-file/index.md)<br>[jvm]<br>open override fun [load]([jvm]load.md)(path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [ProtoFile](../-proto-file/index.md)<br>[native]<br>open override fun [load]([native]load.md)(path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [ProtoFile](../-proto-file/index.md) |
| [loadProfile](../-profile-loader/load-profile.md) | [common, js, jvm, native]<br>[common]<br>abstract fun [loadProfile](../-profile-loader/load-profile.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), schema: [Schema](../-schema/index.md)): [Profile](../-profile/index.md)<br>[js]<br>open override fun [loadProfile]([js]load-profile.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), schema: [Schema](../-schema/index.md)): [Profile](../-profile/index.md)<br>[jvm]<br>open override fun [loadProfile]([jvm]load-profile.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), schema: [Schema](../-schema/index.md)): [Profile](../-profile/index.md)<br>[native]<br>open override fun [loadProfile]([native]load-profile.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), schema: [Schema](../-schema/index.md)): [Profile](../-profile/index.md) |
| [loadSchema](load-schema.md) | [common, js, jvm, native]<br>[common]<br>expect fun [loadSchema](load-schema.md)(): [Schema](../-schema/index.md)<br>[js, jvm, native]<br>actual fun [loadSchema](load-schema.md)(): [Schema](../-schema/index.md) |
| [withErrors](../-loader/with-errors.md) | [common]<br>abstract fun [withErrors](../-loader/with-errors.md)(errors: [ErrorCollector](../-error-collector/index.md)): [Loader](../-loader/index.md)<br>Returns a new loader that reports failures to [errors](../-loader/with-errors.md).<br>[js]<br>open override fun [withErrors]([js]with-errors.md)(errors: [ErrorCollector](../-error-collector/index.md)): [SchemaLoader](index.md)<br>Returns a new loader that reports failures to [errors]([js]with-errors.md).<br>[jvm]<br>open override fun [withErrors]([jvm]with-errors.md)(errors: [ErrorCollector](../-error-collector/index.md)): [SchemaLoader](index.md)<br>Returns a new loader that reports failures to [errors]([jvm]with-errors.md).<br>[native]<br>open override fun [withErrors]([native]with-errors.md)(errors: [ErrorCollector](../-error-collector/index.md)): [SchemaLoader](index.md)<br>Returns a new loader that reports failures to [errors]([native]with-errors.md). |
