//[wire-schema](../../index.md)/[com.squareup.wire.schema](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [AdapterConstant](-adapter-constant/index.md) | [jvm]<br>data class [AdapterConstant](-adapter-constant/index.md)(val javaClassName: ClassName, val kotlinClassName: ClassName, val memberName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>A constant field that identifies a ProtoAdapter. This should be a string like like `com.squareup.dinosaurs.Dinosaur#ADAPTER` with a fully qualified class name, a `#`, and a field name. |
| [ClaimedDefinitions](-claimed-definitions/index.md) | [common]<br>class [ClaimedDefinitions](-claimed-definitions/index.md)<br>[ClaimedDefinitions](-claimed-definitions/index.md) tracks handled objects: [Type](-type/index.md)s, [Service](-service/index.md)s, and [Field](-field/index.md)s. A [SchemaHandler](-schema-handler/index.md) is to first check if an object has already been claimed; if yes, it is not to handle it. Otherwise, the [SchemaHandler](-schema-handler/index.md) is to handle the object and [claim](-claimed-definitions/claim.md) it. It is an error for a [SchemaHandler](-schema-handler/index.md) to handle an object which has already been claimed. |
| [ClaimedPaths](-claimed-paths/index.md) | [common]<br>class [ClaimedPaths](-claimed-paths/index.md)<br>[ClaimedPaths](-claimed-paths/index.md) tracks generated files' Paths. [Schema handlers](-schema-handler/index.md) who generate files are to [claim](-claimed-paths/claim.md) each generated file's path. It is an error to generate different [Type](-type/index.md)s or [Service](-service/index.md)s to the same file and [ClaimedPaths](-claimed-paths/index.md) will throw when generation conflicts happen. |
| [CoreLoader](-core-loader/index.md) | [common]<br>expect object [CoreLoader](-core-loader/index.md) : [Loader](-loader/index.md)<br>A specific [Loader](-loader/index.md) which loads Wire's runtime proto files such as `google/protobuf/descriptor.proto` or `wire/extensions.proto`.<br>[js, native]<br>[js, native]<br>actual object [CoreLoader](-core-loader/index.md) : [Loader](-loader/index.md)<br>[jvm]<br>actual object [CoreLoader](-core-loader/index.md) : [Loader](-loader/index.md)<br>A loader that can only load built-in `.proto` files: |
| [EmittingRules](-emitting-rules/index.md) | [common]<br>class [EmittingRules](-emitting-rules/index.md)<br>A set of rules that describes which types to generate. |
| [EnclosingType](-enclosing-type/index.md) | [common]<br>data class [EnclosingType](-enclosing-type/index.md)(val location: [Location](-location/index.md), val type: [ProtoType](-proto-type/index.md), val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val nestedTypes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Type](-type/index.md)&gt;, val nestedExtendList: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Extend](-extend/index.md)&gt;, val syntax: Syntax) : [Type](-type/index.md)<br>An empty type which only holds nested types. |
| [EnumConstant](-enum-constant/index.md) | [common]<br>data class [EnumConstant](-enum-constant/index.md)(val location: [Location](-location/index.md), val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), val documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val options: [Options](-options/index.md)) |
| [EnumType](-enum-type/index.md) | [common]<br>data class [EnumType](-enum-type/index.md)(val type: [ProtoType](-proto-type/index.md), val location: [Location](-location/index.md), val documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val constants: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[EnumConstant](-enum-constant/index.md)&gt;, reserveds: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Reserved](-reserved/index.md)&gt;, val options: [Options](-options/index.md), val syntax: Syntax) : [Type](-type/index.md) |
| [ErrorCollector](-error-collector/index.md) | [common]<br>class [ErrorCollector](-error-collector/index.md)<br>Collects errors to be reported as a batch. Errors include both a detail message plus context of where they occurred within the schema. |
| [EventListener](-event-listener/index.md) | [common]<br>abstract class [EventListener](-event-listener/index.md)<br>Listener for metrics events. Extend this class to monitor WireRun and all [schema handlers](-schema-handler/index.md) involved in the Protobuf schema manipulation. |
| [Extend](-extend/index.md) | [common]<br>data class [Extend](-extend/index.md)(val location: [Location](-location/index.md), val documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val fields: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Field](-field/index.md)&gt;) |
| [Extensions](-extensions/index.md) | [common]<br>data class [Extensions](-extensions/index.md)(val location: [Location](-location/index.md), val documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val values: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;) |
| [Field](-field/index.md) | [common]<br>data class [Field](-field/index.md)(val namespaces: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, val location: [Location](-location/index.md), val label: [Field.Label](-field/-label/index.md)?, val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val tag: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), val default: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, elementType: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val options: [Options](-options/index.md), val isExtension: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), val isOneOf: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), val declaredJsonName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) |
| [LinkedOptionEntry](-linked-option-entry/index.md) | [common]<br>data class [LinkedOptionEntry](-linked-option-entry/index.md)(val optionElement: [OptionElement](../com.squareup.wire.schema.internal.parser/-option-element/index.md), val protoMember: [ProtoMember](-proto-member/index.md), val value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?) |
| [Linker](-linker/index.md) | [common]<br>class [Linker](-linker/index.md)<br>Links local field types and option types to the corresponding declarations. |
| [Loader](-loader/index.md) | [common]<br>interface [Loader](-loader/index.md)<br>Loads other files as needed by their import path. |
| [Location](-location/index.md) | [common]<br>data class [Location](-location/index.md)(val base: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val line: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = -1, val column: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = -1)<br>Locates a .proto file, or a position within a .proto file, on the file system. This includes a base directory or a .jar file, and a path relative to that base. |
| [MarkSet](-mark-set/index.md) | [common]<br>class [MarkSet](-mark-set/index.md)(val pruningRules: [PruningRules](-pruning-rules/index.md))<br>A mark set is used in three phases: |
| [MessageType](-message-type/index.md) | [common]<br>data class [MessageType](-message-type/index.md)(val type: [ProtoType](-proto-type/index.md), val location: [Location](-location/index.md), val documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val declaredFields: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Field](-field/index.md)&gt;, val extensionFields: [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[Field](-field/index.md)&gt;, val oneOfs: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[OneOf](-one-of/index.md)&gt;, val nestedTypes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Type](-type/index.md)&gt;, val nestedExtendList: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Extend](-extend/index.md)&gt;, val extensionsList: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Extensions](-extensions/index.md)&gt;, reserveds: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Reserved](-reserved/index.md)&gt;, val options: [Options](-options/index.md), val syntax: Syntax) : [Type](-type/index.md) |
| [Multimap](-multimap/index.md) | [common, js, native, jvm]<br>[common]<br>expect interface [Multimap](-multimap/index.md)&lt;[K](-multimap/index.md), [V](-multimap/index.md)&gt;<br>[js, native]<br>actual interface [Multimap](-multimap/index.md)&lt;[K](-multimap/index.md), [V](-multimap/index.md)&gt;<br>[jvm]<br>actual typealias [Multimap](-multimap/index.md)&lt;[K](-multimap/index.md), [V](-multimap/index.md)&gt; = com.google.common.collect.Multimap&lt;[K](-multimap/index.md), [V](-multimap/index.md)&gt; |
| [OneOf](-one-of/index.md) | [common]<br>data class [OneOf](-one-of/index.md)(val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val fields: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Field](-field/index.md)&gt;, val location: [Location](-location/index.md), val options: [Options](-options/index.md)) |
| [Options](-options/index.md) | [common]<br>class [Options](-options/index.md)(optionType: [ProtoType](-proto-type/index.md), optionElements: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[OptionElement](../com.squareup.wire.schema.internal.parser/-option-element/index.md)&gt;)<br>A set of options declared on a message declaration, field declaration, enum declaration, enum constant declaration, service declaration, RPC method declaration, or proto file declaration. Options values may be arbitrary protocol buffer messages, but must be valid protocol buffer messages. |
| [Profile](-profile/index.md) | [common, js, native]<br>[common]<br>expect class [Profile](-profile/index.md)(profileFiles: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ProfileFileElement](../com.squareup.wire.schema.internal/-profile-file-element/index.md)&gt; = emptyList())<br>[js, native]<br>actual class [Profile](-profile/index.md)(profileFiles: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ProfileFileElement](../com.squareup.wire.schema.internal/-profile-file-element/index.md)&gt;)<br>[jvm]<br>actual class [Profile](-profile/index.md)(profileFiles: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ProfileFileElement](../com.squareup.wire.schema.internal/-profile-file-element/index.md)&gt;)<br>Describes how to map `.proto` to `.java`. A single repository of `.proto` files may have multiple profiles; for example a project may target both Android and Java. |
| [ProfileLoader](-profile-loader/index.md) | [common]<br>interface [ProfileLoader](-profile-loader/index.md) |
| [ProtoFile](-proto-file/index.md) | [common]<br>data class [ProtoFile](-proto-file/index.md)(val location: [Location](-location/index.md), val imports: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, val publicImports: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, val packageName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, val types: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Type](-type/index.md)&gt;, val services: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Service](-service/index.md)&gt;, val extendList: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Extend](-extend/index.md)&gt;, val options: [Options](-options/index.md), val syntax: Syntax?) |
| [ProtoMember](-proto-member/index.md) | [common]<br>class [ProtoMember](-proto-member/index.md)<br>Identifies a field, enum or RPC on a declaring type. Members are encoded as strings containing a type name, a hash, and a member name, like `squareup.dinosaurs.Dinosaur#length_meters`. |
| [ProtoType](-proto-type/index.md) | [common]<br>class [ProtoType](-proto-type/index.md)<br>Names a protocol buffer message, enumerated type, service, map, or a scalar. This class models a fully-qualified name using the protocol buffer package. |
| [Pruner](-pruner/index.md) | [common]<br>class [Pruner](-pruner/index.md)(schema: [Schema](-schema/index.md), pruningRules: [PruningRules](-pruning-rules/index.md))<br>Creates a new schema that contains only the types selected by the pruning rules, including their transitive dependencies. |
| [PruningRules](-pruning-rules/index.md) | [common]<br>class [PruningRules](-pruning-rules/index.md)<br>A set of rules that describes which types and members to retain and which to remove. |
| [Reserved](-reserved/index.md) | [common]<br>data class [Reserved](-reserved/index.md)(val location: [Location](-location/index.md), val documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val values: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;) |
| [Rpc](-rpc/index.md) | [common]<br>data class [Rpc](-rpc/index.md)(val location: [Location](-location/index.md), val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), requestTypeElement: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), responseTypeElement: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val requestStreaming: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), val responseStreaming: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), val options: [Options](-options/index.md)) |
| [Schema](-schema/index.md) | [common]<br>class [Schema](-schema/index.md)<br>A collection of .proto files that describe a set of messages. A schema is *linked*: each field's type name is resolved to the corresponding type definition. |
| [SchemaException](-schema-exception/index.md) | [common]<br>class [SchemaException](-schema-exception/index.md)(errors: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;) : [RuntimeException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-runtime-exception/index.html) |
| [SchemaHandler](-schema-handler/index.md) | [common]<br>abstract class [SchemaHandler](-schema-handler/index.md)<br>A [SchemaHandler](-schema-handler/handle.md)s [Schema](-schema/index.md)! |
| [SchemaLoader](-schema-loader/index.md) | [common]<br>expect class [SchemaLoader](-schema-loader/index.md)(fileSystem: FileSystem) : [Loader](-loader/index.md), [ProfileLoader](-profile-loader/index.md)<br>Load proto files and their transitive dependencies and parse them. Keep track of which files were loaded from where so that we can use that information later when deciding what to generate.<br>[js, jvm, native]<br>[js, jvm, native]<br>actual class [SchemaLoader](-schema-loader/index.md)(fileSystem: FileSystem) : [Loader](-loader/index.md), [ProfileLoader](-profile-loader/index.md) |
| [Service](-service/index.md) | [common]<br>data class [Service](-service/index.md)(val type: [ProtoType](-proto-type/index.md), val location: [Location](-location/index.md), val documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val rpcs: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Rpc](-rpc/index.md)&gt;, val options: [Options](-options/index.md)) |
| [SyntaxRules](-syntax-rules/index.md) | [common]<br>interface [SyntaxRules](-syntax-rules/index.md)<br>A set of rules which defines schema requirements for a specific Syntax. |
| [Target](-target/index.md) | [common]<br>abstract class [Target](-target/index.md) : Serializable |
| [Type](-type/index.md) | [common]<br>sealed class [Type](-type/index.md) |
| [WireRun](-wire-run/index.md) | [common]<br>class [WireRun](-wire-run/index.md)(val sourcePath: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Location](-location/index.md)&gt;, val protoPath: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Location](-location/index.md)&gt; = listOf(), val treeShakingRoots: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; = listOf(&quot;*&quot;), val treeShakingRubbish: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; = listOf(), val moves: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[TypeMover.Move](../com.squareup.wire.schema.internal/-type-mover/-move/index.md)&gt; = listOf(), val sinceVersion: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null, val untilVersion: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null, val onlyVersion: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null, val targets: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Target](-target/index.md)&gt;, val modules: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [WireRun.Module](-wire-run/-module/index.md)&gt; = emptyMap(), val permitPackageCycles: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, val eventListeners: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[EventListener](-event-listener/index.md)&gt; = listOf(), val rejectUnusedRootsOrPrunes: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)<br>An invocation of the Wire compiler. Each invocation performs the following operations: |

## Properties

| Name | Summary |
|---|---|
| [WIRE_RUNTIME_JAR](-w-i-r-e_-r-u-n-t-i-m-e_-j-a-r.md) | [common]<br>const val [WIRE_RUNTIME_JAR](-w-i-r-e_-r-u-n-t-i-m-e_-j-a-r.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>A special base directory used for Wire's built-in .proto files. |

## Functions

| Name | Summary |
|---|---|
| [isWireRuntimeProto](is-wire-runtime-proto.md) | [common]<br>fun [isWireRuntimeProto](is-wire-runtime-proto.md)(location: [Location](-location/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[common]<br>fun [isWireRuntimeProto](is-wire-runtime-proto.md)(path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [path](is-wire-runtime-proto.md) is bundled in the wire runtime. |
| [newEventListenerFactory](new-event-listener-factory.md) | [jvm]<br>fun [newEventListenerFactory](new-event-listener-factory.md)(eventListenerFactoryClass: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [EventListener.Factory](-event-listener/-factory/index.md)<br>Create and return an instance of [EventListener.Factory](-event-listener/-factory/index.md). |
| [newLoggerFactory](new-logger-factory.md) | [jvm]<br>fun [newLoggerFactory](new-logger-factory.md)(loggerFactoryClass: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [WireLogger.Factory](../com.squareup.wire/-wire-logger/-factory/index.md)<br>Create and return an instance of [WireLogger.Factory](../com.squareup.wire/-wire-logger/-factory/index.md). |
