/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFilePath;
import com.squareup.wire.schema.Root;
import com.squareup.wire.schema.internal.UtilKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/squareup/wire/schema/DirectoryRoot;", "Lcom/squareup/wire/schema/Root;", "base", "", "fileSystem", "Lokio/FileSystem;", "rootDirectory", "Lokio/Path;", "<init>", "(Ljava/lang/String;Lokio/FileSystem;Lokio/Path;)V", "getBase", "()Ljava/lang/String;", "getFileSystem", "()Lokio/FileSystem;", "getRootDirectory", "()Lokio/Path;", "allProtoFiles", "", "Lcom/squareup/wire/schema/ProtoFilePath;", "resolve", "import", "toString", "wire-schema"})
public final class DirectoryRoot
extends Root {
    @NotNull
    private final String base;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path rootDirectory;

    public DirectoryRoot(@NotNull String base, @NotNull FileSystem fileSystem, @NotNull Path rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        super(null);
        this.base = base;
        this.fileSystem = fileSystem;
        this.rootDirectory = rootDirectory;
    }

    @Override
    @NotNull
    public String getBase() {
        return this.base;
    }

    @NotNull
    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @NotNull
    public final Path getRootDirectory() {
        return this.rootDirectory;
    }

    @Override
    @NotNull
    public Set<ProtoFilePath> allProtoFiles() {
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)this.fileSystem.listRecursively(this.rootDirectory), DirectoryRoot::allProtoFiles$lambda$0), arg_0 -> DirectoryRoot.allProtoFiles$lambda$1(this, arg_0)));
    }

    @Override
    @Nullable
    public ProtoFilePath resolve(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"import");
        Path resolved = this.rootDirectory.resolve(string);
        if (!this.fileSystem.exists(resolved)) {
            return null;
        }
        return new ProtoFilePath(Location.Companion.get(this.getBase(), UtilKt.withUnixSlashes(Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null)).toString()), this.fileSystem, resolved);
    }

    @NotNull
    public String toString() {
        return this.getBase();
    }

    private static final boolean allProtoFiles$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.endsWith$default((String)it.toString(), (String)".proto", (boolean)false, (int)2, null);
    }

    private static final ProtoFilePath allProtoFiles$lambda$1(DirectoryRoot this$0, Path descendant) {
        Intrinsics.checkNotNullParameter((Object)descendant, (String)"descendant");
        Location location = Location.Companion.get(this$0.getBase(), UtilKt.withUnixSlashes(descendant.relativeTo(this$0.rootDirectory)).toString());
        return new ProtoFilePath(location, this$0.fileSystem, descendant);
    }
}

