/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.ProtoType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/squareup/wire/schema/EmittingRules;", "", "builder", "Lcom/squareup/wire/schema/EmittingRules$Builder;", "<init>", "(Lcom/squareup/wire/schema/EmittingRules$Builder;)V", "()V", "includes", "", "", "excludes", "usedIncludes", "", "usedExcludes", "isEmpty", "", "()Z", "type", "Lcom/squareup/wire/schema/ProtoType;", "identifier", "exclude", "unusedIncludes", "unusedExcludes", "Builder", "Companion", "wire-schema"})
public final class EmittingRules {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> includes;
    @NotNull
    private final Set<String> excludes;
    @NotNull
    private final Set<String> usedIncludes;
    @NotNull
    private final Set<String> usedExcludes;

    private EmittingRules(Builder builder) {
        this.includes = CollectionsKt.toSet((Iterable)builder.getIncludes$wire_schema());
        this.excludes = CollectionsKt.toSet((Iterable)builder.getExcludes$wire_schema());
        this.usedIncludes = new LinkedHashSet();
        this.usedExcludes = new LinkedHashSet();
    }

    public EmittingRules() {
        this(new Builder());
    }

    public final boolean isEmpty() {
        return this.includes.isEmpty() && this.excludes.isEmpty();
    }

    public final boolean includes(@NotNull ProtoType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.includes(type.toString());
    }

    private final boolean includes(String identifier) {
        boolean isIncluded;
        if (this.includes.isEmpty()) {
            return !this.exclude(identifier);
        }
        String includeMatch = null;
        String excludeMatch = null;
        String rule = identifier;
        while (rule != null) {
            if (excludeMatch == null && this.excludes.contains(rule)) {
                excludeMatch = rule;
            }
            if (includeMatch == null && this.includes.contains(rule)) {
                includeMatch = rule;
            }
            rule = Companion.enclosing$wire_schema(rule);
        }
        boolean bl = excludeMatch != null && includeMatch != null ? excludeMatch.length() < includeMatch.length() : (excludeMatch != null ? false : (isIncluded = includeMatch != null));
        if (isIncluded) {
            String string = includeMatch;
            Intrinsics.checkNotNull((Object)string);
            this.usedIncludes.add(string);
        } else if (excludeMatch != null) {
            this.usedExcludes.add(excludeMatch);
        }
        return isIncluded;
    }

    private final boolean exclude(String identifier) {
        boolean excluded;
        String includeMatch = null;
        String excludeMatch = null;
        String rule = identifier;
        while (rule != null) {
            if (excludeMatch == null && this.excludes.contains(rule)) {
                excludeMatch = rule;
            }
            if (includeMatch == null && this.includes.contains(rule)) {
                includeMatch = rule;
            }
            rule = Companion.enclosing$wire_schema(rule);
        }
        boolean bl = excludeMatch != null && includeMatch != null ? excludeMatch.length() >= includeMatch.length() : (excluded = excludeMatch != null);
        if (excluded) {
            String string = excludeMatch;
            Intrinsics.checkNotNull((Object)string);
            this.usedExcludes.add(string);
        }
        return excluded;
    }

    @NotNull
    public final Set<String> unusedIncludes() {
        return SetsKt.minus(this.includes, (Iterable)this.usedIncludes);
    }

    @NotNull
    public final Set<String> unusedExcludes() {
        return SetsKt.minus(this.excludes, (Iterable)this.usedExcludes);
    }

    public /* synthetic */ EmittingRules(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0006J\u0014\u0010\u000b\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eJ\u0014\u0010\u000f\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/squareup/wire/schema/EmittingRules$Builder;", "", "<init>", "()V", "includes", "", "", "getIncludes$wire_schema", "()Ljava/util/Set;", "excludes", "getExcludes$wire_schema", "include", "identifier", "identifiers", "", "exclude", "build", "Lcom/squareup/wire/schema/EmittingRules;", "wire-schema"})
    public static final class Builder {
        @NotNull
        private final Set<String> includes = new LinkedHashSet();
        @NotNull
        private final Set<String> excludes = new LinkedHashSet();

        @NotNull
        public final Set<String> getIncludes$wire_schema() {
            return this.includes;
        }

        @NotNull
        public final Set<String> getExcludes$wire_schema() {
            return this.excludes;
        }

        @NotNull
        public final Builder include(@NotNull String identifier) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Builder $this$include_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$include_u24lambda_u240.includes.add(identifier);
            return builder;
        }

        @NotNull
        public final Builder include(@NotNull Iterable<String> identifiers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
            Builder $this$include_u24lambda_u241 = builder = this;
            boolean bl = false;
            CollectionsKt.addAll((Collection)$this$include_u24lambda_u241.includes, identifiers);
            return builder;
        }

        @NotNull
        public final Builder exclude(@NotNull Iterable<String> identifiers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(identifiers, (String)"identifiers");
            Builder $this$exclude_u24lambda_u240 = builder = this;
            boolean bl = false;
            CollectionsKt.addAll((Collection)$this$exclude_u24lambda_u240.excludes, identifiers);
            return builder;
        }

        @NotNull
        public final Builder exclude(@NotNull String identifier) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Builder $this$exclude_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$exclude_u24lambda_u241.excludes.add(identifier);
            return builder;
        }

        @NotNull
        public final EmittingRules build() {
            Set conflictingRules = CollectionsKt.intersect((Iterable)this.includes, (Iterable)this.excludes);
            if (!conflictingRules.isEmpty()) {
                boolean bl = false;
                String string = "same rule(s) defined in both includes and excludes: " + CollectionsKt.joinToString$default((Iterable)conflictingRules, null, null, null, (int)0, null, null, (int)63, null);
                throw new IllegalStateException(string.toString());
            }
            return new EmittingRules(this, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/squareup/wire/schema/EmittingRules$Companion;", "", "<init>", "()V", "enclosing", "", "identifier", "enclosing$wire_schema", "wire-schema"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String enclosing$wire_schema(@NotNull String identifier) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            int from = StringsKt.endsWith$default((String)identifier, (String)".*", (boolean)false, (int)2, null) ? identifier.length() - 3 : identifier.length() - 1;
            int dot = StringsKt.lastIndexOf$default((CharSequence)identifier, (char)'.', (int)from, (boolean)false, (int)4, null);
            if (dot != -1) {
                StringBuilder stringBuilder = new StringBuilder();
                String string = identifier.substring(0, dot);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return stringBuilder.append(string).append(".*").toString();
            }
            if (!Intrinsics.areEqual((Object)identifier, (Object)"*")) {
                return "*";
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

