/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.SyntaxRules;
import com.squareup.wire.schema.Type;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ$\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0018J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020\u0018J\u0018\u0010!\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\"\u001a\u00020\u0018J\u000e\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u000eJ(\u0010%\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u000eH\u0002J\u000e\u0010(\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u000eJ\u0006\u0010)\u001a\u00020\u0018J\u0016\u0010*\u001a\u00020\u00182\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001f0,H\u0002J\u000e\u0010-\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010.\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u000eJ\u000e\u0010/\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u000eJ\u000e\u0010$\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/squareup/wire/schema/FileLinker;", "", "protoFile", "Lcom/squareup/wire/schema/ProtoFile;", "linker", "Lcom/squareup/wire/schema/Linker;", "<init>", "(Lcom/squareup/wire/schema/ProtoFile;Lcom/squareup/wire/schema/Linker;)V", "getProtoFile", "()Lcom/squareup/wire/schema/ProtoFile;", "effectiveImports", "", "", "typesRegistered", "", "extensionsLinked", "importedExtensionsRegistered", "extensionOptionsLinked", "importedExtensionOptionsLinked", "fileOptionsLinked", "typesWithMembersLinked", "", "Lcom/squareup/wire/schema/ProtoType;", "addImportsRecursive", "", "sink", "paths", "", "requireTypesRegistered", "addTypes", "type", "Lcom/squareup/wire/schema/Type;", "requireExtensionsLinked", "linkNestedExtensions", "requireImportedExtensionsRegistered", "requireExtensionOptionsLinked", "validate", "linkNestedExtensionOptions", "syntaxRules", "Lcom/squareup/wire/schema/SyntaxRules;", "requireImportedExtensionOptionsLinked", "linkMembers", "linkMembersRecursive", "types", "", "requireMembersLinked", "linkOptions", "requireFileOptionsLinked", "wire-schema"})
public final class FileLinker {
    @NotNull
    private final ProtoFile protoFile;
    @NotNull
    private final Linker linker;
    @Nullable
    private Set<String> effectiveImports;
    private boolean typesRegistered;
    private boolean extensionsLinked;
    private boolean importedExtensionsRegistered;
    private boolean extensionOptionsLinked;
    private boolean importedExtensionOptionsLinked;
    private boolean fileOptionsLinked;
    @NotNull
    private final Set<ProtoType> typesWithMembersLinked;

    public FileLinker(@NotNull ProtoFile protoFile, @NotNull Linker linker) {
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        Intrinsics.checkNotNullParameter((Object)linker, (String)"linker");
        this.protoFile = protoFile;
        this.linker = linker;
        this.typesWithMembersLinked = new LinkedHashSet();
    }

    @NotNull
    public final ProtoFile getProtoFile() {
        return this.protoFile;
    }

    @NotNull
    public final Set<String> effectiveImports() {
        if (this.effectiveImports == null) {
            Set sink = new LinkedHashSet();
            this.addImportsRecursive(sink, (Collection<String>)this.protoFile.getImports());
            this.addImportsRecursive(sink, (Collection<String>)this.protoFile.getPublicImports());
            this.effectiveImports = new LinkedHashSet(sink);
        }
        Set<String> set = this.effectiveImports;
        Intrinsics.checkNotNull(set);
        return set;
    }

    private final void addImportsRecursive(Set<String> sink, Collection<String> paths) {
        for (String path : paths) {
            if (!sink.add(path)) continue;
            FileLinker fileLinker = this.linker.getFileLinker$wire_schema(path);
            this.addImportsRecursive(sink, (Collection<String>)fileLinker.protoFile.getPublicImports());
            if (!this.linker.getLoadExhaustively()) continue;
            this.addImportsRecursive(sink, (Collection<String>)fileLinker.protoFile.getImports());
        }
    }

    public final void requireTypesRegistered() {
        if (this.typesRegistered) {
            return;
        }
        this.typesRegistered = true;
        for (Type type : this.protoFile.getTypes()) {
            this.addTypes(type);
        }
    }

    private final void addTypes(Type type) {
        this.linker.addType(type.getType(), type);
        for (Type nestedType : type.getNestedTypes()) {
            this.addTypes(nestedType);
        }
    }

    public final void requireExtensionsLinked() {
        if (this.extensionsLinked) {
            return;
        }
        this.extensionsLinked = true;
        this.requireTypesRegistered();
        for (Extend extend : this.protoFile.getExtendList()) {
            extend.link(this.linker);
        }
        for (Type type : this.protoFile.getTypes()) {
            this.linkNestedExtensions(type, this.linker);
        }
    }

    private final void linkNestedExtensions(Type type, Linker linker) {
        Linker typeLinker = linker.withContext(type);
        for (Extend extend : type.getNestedExtendList()) {
            extend.link(typeLinker);
        }
        for (Type nested : type.getNestedTypes()) {
            this.linkNestedExtensions(nested, typeLinker);
        }
    }

    public final void requireImportedExtensionsRegistered() {
        if (this.importedExtensionsRegistered) {
            return;
        }
        this.importedExtensionsRegistered = true;
        for (FileLinker importedFileLinker : this.linker.contextImportedTypes$wire_schema()) {
            importedFileLinker.requireExtensionsLinked();
        }
    }

    public final void requireExtensionOptionsLinked(boolean validate) {
        if (this.extensionOptionsLinked) {
            return;
        }
        this.extensionOptionsLinked = true;
        SyntaxRules syntaxRules = SyntaxRules.Companion.get(this.protoFile.getSyntax());
        for (Extend extend : this.protoFile.getExtendList()) {
            extend.linkOptions(this.linker, syntaxRules, validate);
        }
        for (Type type : this.protoFile.getTypes()) {
            this.linkNestedExtensionOptions(type, this.linker, syntaxRules, validate);
        }
    }

    private final void linkNestedExtensionOptions(Type type, Linker linker, SyntaxRules syntaxRules, boolean validate) {
        Linker typeLinker = linker.withContext(type);
        for (Extend extend : type.getNestedExtendList()) {
            extend.linkOptions(typeLinker, syntaxRules, validate);
        }
        for (Type nested : type.getNestedTypes()) {
            this.linkNestedExtensionOptions(nested, typeLinker, syntaxRules, validate);
        }
    }

    public final void requireImportedExtensionOptionsLinked(boolean validate) {
        if (this.importedExtensionOptionsLinked) {
            return;
        }
        this.importedExtensionOptionsLinked = true;
        for (FileLinker importedFileLinker : this.linker.contextImportedTypes$wire_schema()) {
            importedFileLinker.requireExtensionOptionsLinked(validate);
        }
    }

    public final void linkMembers() {
        this.linkMembersRecursive(this.protoFile.getTypes());
        for (Service service : this.protoFile.getServices()) {
            service.link(this.linker);
        }
    }

    private final void linkMembersRecursive(List<? extends Type> types) {
        for (Type type : types) {
            this.requireMembersLinked(type);
            this.linkMembersRecursive(type.getNestedTypes());
        }
    }

    public final void requireMembersLinked(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.typesWithMembersLinked.add(type.getType())) {
            type.linkMembers(this.linker);
        }
    }

    public final void linkOptions(@NotNull SyntaxRules syntaxRules, boolean validate) {
        Intrinsics.checkNotNullParameter((Object)syntaxRules, (String)"syntaxRules");
        this.requireFileOptionsLinked(validate);
        this.requireExtensionOptionsLinked(validate);
        for (Type type : this.protoFile.getTypes()) {
            type.linkOptions(this.linker, syntaxRules, validate);
        }
        for (Service service : this.protoFile.getServices()) {
            service.linkOptions(this.linker, validate);
        }
    }

    public final void requireFileOptionsLinked(boolean validate) {
        if (this.fileOptionsLinked) {
            return;
        }
        this.fileOptionsLinked = true;
        this.protoFile.linkOptions(this.linker, validate);
    }

    public final void validate(@NotNull SyntaxRules syntaxRules) {
        Intrinsics.checkNotNullParameter((Object)syntaxRules, (String)"syntaxRules");
        for (Type type : this.protoFile.getTypes()) {
            type.validate(this.linker, syntaxRules);
        }
        for (Service service : this.protoFile.getServices()) {
            service.validate(this.linker);
        }
        for (Extend extend : this.protoFile.getExtendList()) {
            extend.validate(this.linker, syntaxRules);
        }
    }
}

