//[wire-schema](../../../index.md)/[com.squareup.wire](../index.md)/[WireLogger](index.md)

# WireLogger

[common]\
interface [WireLogger](index.md)

Logger class used by com.squareup.wire.schema.WireRun and com.squareup.wire.schema.Target.SchemaHandler to log information related to processing the protobuf [Schema](../../com.squareup.wire.schema/-schema/index.md).

## Functions

| Name | Summary |
|---|---|
| [artifactHandled](artifact-handled.md) | [common]<br>abstract fun [artifactHandled](artifact-handled.md)(outputPath: &lt;ERROR CLASS&gt;, qualifiedName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), targetName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>This is called when an artifact is handled by a com.squareup.wire.schema.Target.SchemaHandler. |
| [artifactSkipped](artifact-skipped.md) | [common]<br>abstract fun [artifactSkipped](artifact-skipped.md)(type: [ProtoType](../../com.squareup.wire.schema/-proto-type/index.md), targetName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>This is called when an artifact has been passed down to a com.squareup.wire.schema.Target.SchemaHandler but has been skipped. This is useful for dry-runs. |
| [unusedExcludesInTarget](unused-excludes-in-target.md) | [common]<br>abstract fun [unusedExcludesInTarget](unused-excludes-in-target.md)(unusedExcludes: [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;)<br>This is called if some excludes values have not been used by the target they were defined in. Note that excludes should contain package names (suffixed with .*) and type names only. It should not contain member names, nor file paths. Unused excludes can happen if the referenced type or service isn't part of the parsed and pruned schema model, or has already been consumed by another preceding target. |
| [unusedIncludesInTarget](unused-includes-in-target.md) | [common]<br>abstract fun [unusedIncludesInTarget](unused-includes-in-target.md)(unusedIncludes: [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;)<br>This is called if some includes values have not been used by the target they were defined in. Note that includes should contain package names (suffixed with .*) and type names only. It should not contain member names, nor file paths. Unused includes can happen if the referenced type or service isn't part of the parsed and pruned schema model, or has already been consumed by another preceding target. |
| [unusedPrunes](unused-prunes.md) | [common]<br>abstract fun [unusedPrunes](unused-prunes.md)(unusedPrunes: [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;)<br>This is called if some prune values have not been used when Wire pruned the schema model. Note that prune should contain package names (suffixed with .*), type names, and member names only. It should not contain file paths. Unused prunes can happen if the referenced type or service isn't part of any .proto files defined in either com.squareup.wire.schema.WireRun.sourcePath or com.squareup.wire.schema.WireRun.protoPath, or if a broader prune value is already defined. |
| [unusedRoots](unused-roots.md) | [common]<br>abstract fun [unusedRoots](unused-roots.md)(unusedRoots: [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;)<br>This is called if some root values have not been used when Wire pruned the schema model. Note that root should contain package names (suffixed with .*), type names, and member names only. It should not contain file paths. Unused roots can happen if the referenced type or service isn't part of any .proto files defined in either com.squareup.wire.schema.WireRun.sourcePath or com.squareup.wire.schema.WireRun.protoPath, or if a broader root value is already defined. |
