[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [LifecycleWorker](./index.md)

# LifecycleWorker

`abstract class LifecycleWorker : `[`Worker`](../-worker/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>`

[Worker](../-worker/index.md) that performs some action when the worker is started and/or stopped.

A [Worker](../-worker/index.md) is stopped when its parent [Workflow](../-workflow/index.md) finishes a render pass without running the
worker, or when the parent workflow is itself torn down.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | [Worker](../-worker/index.md) that performs some action when the worker is started and/or stopped.`LifecycleWorker()` |

### Functions

| Name | Summary |
|---|---|
| [doesSameWorkAs](does-same-work-as.md) | Equates [LifecycleWorker](./index.md)s that have the same concrete class.`open fun doesSameWorkAs(otherWorker: `[`Worker`](../-worker/index.md)`<*>): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [onStarted](on-started.md) | Called when this worker is started. It is executed concurrently with the parent workflow – the first render pass that starts this worker *will not* wait for this method to return, and one or more additional render passes may occur before this method is called. This behavior may change to be more strict in the future.`open fun onStarted(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [onStopped](on-stopped.md) | Called when this worker has been torn down. It is executed concurrently with the parent workflow – the render pass that cancels (stops) this worker *will not* wait for this method to return, and one or more additional render passes may occur before this method is called. This behavior may change to be more strict in the future.`open fun onStopped(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [run](run.md) | Returns a [Flow](#) to execute the work represented by this worker.`fun run(): Flow<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>` |

### Extension Functions

| Name | Summary |
|---|---|
| [transform](../transform.md) | Returns a [Worker](../-worker/index.md) that transforms this [Worker](../-worker/index.md)'s [Flow](#) by calling [transform](../transform.md#com.squareup.workflow$transform(com.squareup.workflow.Worker((com.squareup.workflow.transform.T)), kotlin.Function1((kotlinx.coroutines.flow.Flow((com.squareup.workflow.transform.T)), kotlinx.coroutines.flow.Flow((com.squareup.workflow.transform.R)))))/transform).`fun <T, R> `[`Worker`](../-worker/index.md)`<T>.transform(transform: (Flow<T>) -> Flow<R>): `[`Worker`](../-worker/index.md)`<R>` |
