[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [RenderContext](index.md) / [renderChild](./render-child.md)

# renderChild

`abstract fun <ChildPropsT, ChildOutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, ChildRenderingT> renderChild(child: `[`Workflow`](../-workflow/index.md)`<ChildPropsT, ChildOutputT, ChildRenderingT>, props: ChildPropsT, key: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", handler: (ChildOutputT) -> `[`WorkflowAction`](../-workflow-action/index.md)`<StateT, OutputT>): ChildRenderingT`

Ensures [child](render-child.md#com.squareup.workflow.RenderContext$renderChild(com.squareup.workflow.Workflow((com.squareup.workflow.RenderContext.renderChild.ChildPropsT, com.squareup.workflow.RenderContext.renderChild.ChildOutputT, com.squareup.workflow.RenderContext.renderChild.ChildRenderingT)), com.squareup.workflow.RenderContext.renderChild.ChildPropsT, kotlin.String, kotlin.Function1((com.squareup.workflow.RenderContext.renderChild.ChildOutputT, com.squareup.workflow.WorkflowAction((com.squareup.workflow.RenderContext.StateT, com.squareup.workflow.RenderContext.OutputT)))))/child) is running as a child of this workflow, and returns the result of its
`render` method.

**Never call [StatefulWorkflow.render](../-stateful-workflow/render.md) or [StatelessWorkflow.render](../-stateless-workflow/render.md) directly, always do itthrough this context method.**

1. If the child *wasn't* already running, it will be started either from
    [initialState](#) or its snapshot.
2. If the child *was* already running, The workflow's
    [onInputChanged](#) method is invoked with the previous input
    and this one.
3. The child's `render` method is invoked with `input` and the child's state.

After this method returns, if something happens that trigger's one of `child`'s handlers, and
that handler emits an output, the function passed as [handler](render-child.md#com.squareup.workflow.RenderContext$renderChild(com.squareup.workflow.Workflow((com.squareup.workflow.RenderContext.renderChild.ChildPropsT, com.squareup.workflow.RenderContext.renderChild.ChildOutputT, com.squareup.workflow.RenderContext.renderChild.ChildRenderingT)), com.squareup.workflow.RenderContext.renderChild.ChildPropsT, kotlin.String, kotlin.Function1((com.squareup.workflow.RenderContext.renderChild.ChildOutputT, com.squareup.workflow.WorkflowAction((com.squareup.workflow.RenderContext.StateT, com.squareup.workflow.RenderContext.OutputT)))))/handler) will be invoked with that
output.

### Parameters

`key` - An optional string key that is used to distinguish between workflows of the same
type.