[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [Snapshot](./index.md)

# Snapshot

`class Snapshot`

A lazy wrapper of [ByteString](#). Allows [Workflow](../-workflow/index.md)s to capture their state frequently, without
worrying about performing unnecessary serialization work.

### Properties

| Name | Summary |
|---|---|
| [bytes](bytes.md) | `val bytes: ByteString` |

### Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | Compares `Snapshot`s by comparing their [bytes](bytes.md).`fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | Calculates hashcode using [bytes](bytes.md).`fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [toString](to-string.md) | Returns a `String` describing the [bytes](bytes.md) of this `Snapshot`.`fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Companion Object Properties

| Name | Summary |
|---|---|
| [EMPTY](-e-m-p-t-y.md) | `val EMPTY: `[`Snapshot`](./index.md) |

### Companion Object Functions

| Name | Summary |
|---|---|
| [of](of.md) | `fun of(string: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Snapshot`](./index.md)<br>`fun of(byteString: ByteString): `[`Snapshot`](./index.md)<br>`fun of(lazy: () -> ByteString): `[`Snapshot`](./index.md)<br>`fun of(integer: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`): `[`Snapshot`](./index.md) |
| [write](write.md) | Create a snapshot by writing to a nice ergonomic [BufferedSink](#).`fun write(lazy: (BufferedSink) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Snapshot`](./index.md) |
