[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [StatefulWorkflow](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`StatefulWorkflow()`

A composable, stateful object that can [handle events](../-render-context/action-sink.md),
[delegate to children](../-render-context/render-child.md), [subscribe](../-render-context/running-worker.md) to
arbitrary asynchronous events from the outside world, and be [saved](snapshot-state.md) to a
serialized form to be restored later.

The basic purpose of a `Workflow` is to take some [props](index.md#PropsT) and return a
[rendering](index.md#RenderingT) that serves as a public representation of its current state,
and which can be used to update that state. A rendering typically serves as a view  model,
though this is not assumed, and is not the only use case.

To that end, a workflow may keep track of internal [state](index.md#StateT),
recursively ask other workflows to render themselves, subscribe to data streams from the outside
world, and handle events both from its [renderings](../-render-context/action-sink.md) and from
workflows it's delegated to (its "children"). A `Workflow` may also emit
[output events](index.md#OutputT) up to its parent `Workflow`.

Workflows form a tree, where each workflow can have zero or more child workflows. Child workflows
are started as necessary whenever another workflow asks for them, and are cleaned up automatically
when they're no longer needed. [Props](index.md#PropsT) propagate down the tree, [outputs](index.md#OutputT) and
[renderings](index.md#RenderingT) propagate up the tree.

### Parameters

`PropsT` - Typically a data class that is used to pass configuration information or bits of
state that the workflow can always get from its parent and needn't duplicate in its own state.
May be [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) if the workflow does not need any props data.

`StateT` - Typically a data class that contains all of the internal state for this workflow.
The state is seeded via [props](index.md#PropsT) in [initialState](initial-state.md). It can be [serialized](snapshot-state.md)
and later used to restore the workflow. **Implementations of the `Workflow`interface should not generally contain their own state directly.** They may inject objects like
instances of their child workflows, or network clients, but should not contain directly mutable
state. This is the only type parameter that a parent workflow needn't care about for its children,
and may just use star (`*`) instead of specifying it. May be [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) if the workflow does not have
any internal state (see [StatelessWorkflow](../-stateless-workflow/index.md)).

`OutputT` - Typically a sealed class that represents "events" that this workflow can send
to its parent.
May be [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) if the workflow doesn't need to emit anything.

`RenderingT` - The value returned to this workflow's parent during [composition](render.md).
Typically represents a "view" of this workflow's props, current state, and children's renderings.
A workflow that represents a UI component may use a view model as its rendering type.

**See Also**

[StatelessWorkflow](../-stateless-workflow/index.md)

