[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [StatelessWorkflow](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`StatelessWorkflow()`

Minimal implementation of [Workflow](../-workflow/index.md) that maintains no state of its own.

### Parameters

`PropsT` - Typically a data class that is used to pass configuration information or bits of
state that the workflow can always get from its parent and needn't duplicate in its own state.
May be [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) if the workflow does not need any props data.

`OutputT` - Typically a sealed class that represents "events" that this workflow can send
to its parent.
May be [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) if the workflow doesn't need to emit anything.

`RenderingT` - The value returned to this workflow's parent during [composition](render.md).
Typically represents a "view" of this workflow's props, current state, and children's renderings.
A workflow that represents a UI component may use a view model as its rendering type.

**See Also**

[StatefulWorkflow](../-stateful-workflow/index.md)

