[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [StatelessWorkflow](./index.md)

# StatelessWorkflow

`abstract class StatelessWorkflow<in PropsT, out OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, out RenderingT> : `[`Workflow`](../-workflow/index.md)`<PropsT, OutputT, RenderingT>`

Minimal implementation of [Workflow](../-workflow/index.md) that maintains no state of its own.

### Parameters

`PropsT` - Typically a data class that is used to pass configuration information or bits of
state that the workflow can always get from its parent and needn't duplicate in its own state.
May be [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) if the workflow does not need any props data.

`OutputT` - Typically a sealed class that represents "events" that this workflow can send
to its parent.
May be [Nothing](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html) if the workflow doesn't need to emit anything.

`RenderingT` - The value returned to this workflow's parent during [composition](render.md).
Typically represents a "view" of this workflow's props, current state, and children's renderings.
A workflow that represents a UI component may use a view model as its rendering type.

**See Also**

[StatefulWorkflow](../-stateful-workflow/index.md)

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | Minimal implementation of [Workflow](../-workflow/index.md) that maintains no state of its own.`StatelessWorkflow()` |

### Functions

| Name | Summary |
|---|---|
| [asStatefulWorkflow](as-stateful-workflow.md) | Satisfies the [Workflow](../-workflow/index.md) interface by wrapping `this` in a [StatefulWorkflow](../-stateful-workflow/index.md) with `Unit` state.`fun asStatefulWorkflow(): `[`StatefulWorkflow`](../-stateful-workflow/index.md)`<PropsT, *, OutputT, RenderingT>` |
| [render](render.md) | Called at least once any time one of the following things happens:`abstract fun render(props: PropsT, context: `[`RenderContext`](../-render-context/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>): RenderingT` |

### Extension Functions

| Name | Summary |
|---|---|
| [action](../action.md) | Convenience to create a [WorkflowAction](../-workflow-action/index.md) with parameter types matching those of the receiving [StatefulWorkflow](../-stateful-workflow/index.md). The action will invoke the given [lambda](../action.md#com.squareup.workflow$action(com.squareup.workflow.StatelessWorkflow((com.squareup.workflow.action.PropsT, com.squareup.workflow.action.OutputT, com.squareup.workflow.action.RenderingT)), kotlin.String, kotlin.Function1((com.squareup.workflow.WorkflowAction.Updater((kotlin.Nothing, com.squareup.workflow.action.OutputT)), kotlin.Unit)))/update) when it is [applied](#).`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`StatelessWorkflow`](./index.md)`<PropsT, OutputT, RenderingT>.action(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", update: Updater<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](../-workflow-action/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>`<br>`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, RenderingT> `[`StatelessWorkflow`](./index.md)`<PropsT, OutputT, RenderingT>.action(name: () -> `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, update: Updater<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>.() -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`WorkflowAction`](../-workflow-action/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>` |
| [mapRendering](../map-rendering.md) | Uses the given [function](../map-rendering.md#com.squareup.workflow$mapRendering(com.squareup.workflow.Workflow((com.squareup.workflow.mapRendering.PropsT, com.squareup.workflow.mapRendering.OutputT, com.squareup.workflow.mapRendering.FromRenderingT)), kotlin.Function1((com.squareup.workflow.mapRendering.FromRenderingT, com.squareup.workflow.mapRendering.ToRenderingT)))/transform) to transform a [Workflow](../-workflow/index.md) that renders [FromRenderingT](../map-rendering.md#FromRenderingT) to one renders [ToRenderingT](../map-rendering.md#ToRenderingT),`fun <PropsT, OutputT : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, FromRenderingT, ToRenderingT> `[`Workflow`](../-workflow/index.md)`<PropsT, OutputT, FromRenderingT>.mapRendering(transform: (FromRenderingT) -> ToRenderingT): `[`Workflow`](../-workflow/index.md)`<PropsT, OutputT, ToRenderingT>` |
