[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [StatelessWorkflow](index.md) / [render](./render.md)

# render

`abstract fun render(props: PropsT, context: `[`RenderContext`](../-render-context/index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`, OutputT>): RenderingT`

Called at least once any time one of the following things happens:

* This workflow's [props](render.md#com.squareup.workflow.StatelessWorkflow$render(com.squareup.workflow.StatelessWorkflow.PropsT, com.squareup.workflow.RenderContext((kotlin.Nothing, com.squareup.workflow.StatelessWorkflow.OutputT)))/props) change (via the parent passing a different one in).
* A descendant (immediate or transitive child) workflow:
  * Changes its internal state.
  * Emits an output.

**Never call this method directly.** To get the rendering from a child workflow, pass the child
and any required props to [RenderContext.renderChild](../-render-context/render-child.md).

This method *should not* have any side effects, and in particular should not do anything that
blocks the current thread. It may be called multiple times for the same state. It must do all its
work by calling methods on [context](render.md#com.squareup.workflow.StatelessWorkflow$render(com.squareup.workflow.StatelessWorkflow.PropsT, com.squareup.workflow.RenderContext((kotlin.Nothing, com.squareup.workflow.StatelessWorkflow.OutputT)))/context).

