[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [Worker](index.md) / [createSideEffect](./create-side-effect.md)

# createSideEffect

`fun createSideEffect(block: suspend () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Worker`](index.md)`<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>`

Creates a [Worker](index.md) that just performs some side effects and doesn't emit anything. Run the
worker from your `render` method using [RenderContext.runningWorker](../-render-context/running-worker.md).

E.g.:

```
fun logOnEntered(message: String) = Worker.createSideEffect() {
  println("Entered state: $message")
}

Note that all workers created with this method are equivalent from the point of view of
their [Worker.doesSameWorkAs] methods. A workflow that needs multiple simultaneous
side effects can either bundle them all together into a single `createSideEffect`
call, or can use the `key` parameter to [RenderContext.runningWorker] to prevent conflicts.
```

