[workflow-core](../../index.md) / [com.squareup.workflow](../index.md) / [Worker](index.md) / [doesSameWorkAs](./does-same-work-as.md)

# doesSameWorkAs

`open fun doesSameWorkAs(otherWorker: `[`Worker`](index.md)`<*>): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

Override this method to define equivalence between [Worker](index.md)s.

At the end of every render pass, the set of [Worker](index.md)s that were requested by the workflow are
compared to the set from the last render pass using this method. Equivalent workers are allowed
to keep running. New workers are started ([run](run.md) is called and the returned [Flow](#) is
collected). Old workers are cancelled by cancelling their collecting coroutines.

Implementations of this method should not be based on object identity. For example, a [Worker](index.md)
that performs a network request might check that two workers are requests to the same endpoint
and have the same request data.

Most implementations of this method will check for concrete type equality, and then match
on constructor parameters.

E.g:

```
class SearchWorker(private val query: String): Worker<SearchResult> {
  // run omitted for example.

  override fun doesSameWorkAs(otherWorker: Worker<*>): Boolean =
    otherWorker is SearchWorker && otherWorker.query == query
}
```

