[workflow-core](../index.md) / [com.squareup.workflow](index.md) / [contraMap](./contra-map.md)

# contraMap

`fun <T1, T2> `[`Sink`](-sink/index.md)`<T1>.contraMap(transform: (T2) -> T1): `[`Sink`](-sink/index.md)`<T2>`

Generates a new sink of type [T2](contra-map.md#T2).

Given a [transform](contra-map.md#com.squareup.workflow$contraMap(com.squareup.workflow.Sink((com.squareup.workflow.contraMap.T1)), kotlin.Function1((com.squareup.workflow.contraMap.T2, com.squareup.workflow.contraMap.T1)))/transform) closure, the following code is functionally equivalent:

```
    sink.send(transform(value))

    sink.contraMap(transform).send(value)
```

**Trivia**: Why is this called `contraMap`?
    - `map` turns `Type<T>` into `Type<U>` via `(T)->U`.
    - `contraMap` turns `Type<T>` into `Type<U>` via `(U)->T`

Another way to think about this is: `map` transforms a type by changing the
output types of its API, while `contraMap` transforms a type by changing the
*input* types of its API.

