[workflow-runtime](../../index.md) / [com.squareup.workflow.diagnostic](../index.md) / [WorkflowHierarchyDebugSnapshot](./index.md)

# WorkflowHierarchyDebugSnapshot

`data class WorkflowHierarchyDebugSnapshot`

Describes a tree of snapshots of the states of the entire workflow tree after a particular render
pass.

Emitted from [com.squareup.workflow.WorkflowSession.debugInfo](#).

### Parameters

`workflowType` - A string representation of the type of this workflow.

`state` - The actual state value of the workflow.

`children` - All the child workflows that were rendered by this workflow in the last render
pass. See [ChildWorkflow](-child-workflow/index.md).

### Types

| Name | Summary |
|---|---|
| [ChildWorker](-child-worker/index.md) | Represents a worker that is being run by the workflow represented by a particular [WorkflowHierarchyDebugSnapshot](./index.md).`data class ChildWorker` |
| [ChildWorkflow](-child-workflow/index.md) | Represents a workflow that was rendered by the workflow represented by a particular [WorkflowHierarchyDebugSnapshot](./index.md).`data class ChildWorkflow` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | Describes a tree of snapshots of the states of the entire workflow tree after a particular render pass.`WorkflowHierarchyDebugSnapshot(workflowType: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, props: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, state: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, rendering: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?, children: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ChildWorkflow>, workers: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ChildWorker>)` |

### Properties

| Name | Summary |
|---|---|
| [children](children.md) | All the child workflows that were rendered by this workflow in the last render pass. See [ChildWorkflow](-child-workflow/index.md).`val children: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ChildWorkflow>` |
| [props](props.md) | `val props: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |
| [rendering](rendering.md) | `val rendering: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |
| [state](state.md) | The actual state value of the workflow.`val state: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?` |
| [workers](workers.md) | `val workers: `[`List`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)`<ChildWorker>` |
| [workflowType](workflow-type.md) | A string representation of the type of this workflow.`val workflowType: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Functions

| Name | Summary |
|---|---|
| [toDescriptionString](to-description-string.md) | Generates a multi-line, recursive string describing the update.`fun toDescriptionString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
