[workflow-runtime](../../../../index.md) / [com.squareup.workflow.testing](../../../index.md) / [WorkflowTestParams](../../index.md) / [StartMode](../index.md) / [StartFromCompleteSnapshot](./index.md)

# StartFromCompleteSnapshot

`data class StartFromCompleteSnapshot : StartMode<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>`

Starts the workflow from its initial state (as specified by
[initial state](#)), with a non-null
snapshot. Only applies to [StatefulWorkflow](#)s.

This differs from [StartFromWorkflowSnapshot](../-start-from-workflow-snapshot/index.md) because it represents a complete snapshot of
the entire tree, not just the individual snapshot for the root workflow.

### Parameters

`snapshot` - A [Snapshot](#) that is the entire snapshot from the workflow tree, as returned
by `WorkflowTester.awaitNextSnapshot`. To test with only the snapshot returned by
[snapshotState](#), use
[StartFromWorkflowSnapshot](../-start-from-workflow-snapshot/index.md).

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | Starts the workflow from its initial state (as specified by [initial state](#)), with a non-null snapshot. Only applies to [StatefulWorkflow](#)s.`StartFromCompleteSnapshot(snapshot: Snapshot)` |

### Properties

| Name | Summary |
|---|---|
| [snapshot](snapshot.md) | A [Snapshot](#) that is the entire snapshot from the workflow tree, as returned by `WorkflowTester.awaitNextSnapshot`. To test with only the snapshot returned by [snapshotState](#), use [StartFromWorkflowSnapshot](../-start-from-workflow-snapshot/index.md).`val snapshot: Snapshot` |
