[workflow-runtime](../../../index.md) / [com.squareup.workflow.testing](../../index.md) / [WorkflowTestParams](../index.md) / [StartMode](./index.md)

# StartMode

`sealed class StartMode<out StateT>`

Defines how to start the workflow for tests.

See the documentation on individual cases for more information:

* [StartFresh](-start-fresh.md)
* [StartFromWorkflowSnapshot](-start-from-workflow-snapshot/index.md)
* [StartFromCompleteSnapshot](-start-from-complete-snapshot/index.md)
* [StartFromState](-start-from-state/index.md)

### Types

| Name | Summary |
|---|---|
| [StartFresh](-start-fresh.md) | Starts the workflow from its initial state (as specified by [initial state](#)), with a null snapshot.`object StartFresh : StartMode<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>` |
| [StartFromCompleteSnapshot](-start-from-complete-snapshot/index.md) | Starts the workflow from its initial state (as specified by [initial state](#)), with a non-null snapshot. Only applies to [StatefulWorkflow](#)s.`data class StartFromCompleteSnapshot : StartMode<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>` |
| [StartFromState](-start-from-state/index.md) | Starts the workflow from an exact state. Only applies to [StatefulWorkflow](#)s.`data class StartFromState<StateT> : StartMode<StateT>` |
| [StartFromWorkflowSnapshot](-start-from-workflow-snapshot/index.md) | Starts the workflow from its initial state (as specified by [initial state](#)), with a non-null snapshot.  Only applies to [StatefulWorkflow](#)s.`data class StartFromWorkflowSnapshot : StartMode<`[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>` |
