[workflow-runtime](../../index.md) / [com.squareup.workflow.testing](../index.md) / [WorkflowTestParams](./index.md)

# WorkflowTestParams

`@TestOnly data class WorkflowTestParams<out StateT>`

Defines configuration for workflow testing infrastructure such as `testRender`, `testFromStart`.
and `test`.

### Parameters

`startFrom` - How to start the workflow – see [StartMode](-start-mode/index.md).

`checkRenderIdempotence` - If true, every render method will be called multiple times, to help
suss out any side effects that a render method is trying to perform. This parameter defaults to
`true` since the workflow contract is that `render` will be called an arbitrary number of times
for any given state, so performing side effects in `render` will almost always result in bugs.
It is recommended to leave this on, but if you need to debug a test and don't want to have to
deal with the extra passes, you can temporarily set it to false.

### Types

| Name | Summary |
|---|---|
| [StartMode](-start-mode/index.md) | Defines how to start the workflow for tests.`sealed class StartMode<out StateT>` |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | Defines configuration for workflow testing infrastructure such as `testRender`, `testFromStart`. and `test`.`WorkflowTestParams(startFrom: StartMode<StateT> = StartFresh, checkRenderIdempotence: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = true)` |

### Properties

| Name | Summary |
|---|---|
| [checkRenderIdempotence](check-render-idempotence.md) | If true, every render method will be called multiple times, to help suss out any side effects that a render method is trying to perform. This parameter defaults to `true` since the workflow contract is that `render` will be called an arbitrary number of times for any given state, so performing side effects in `render` will almost always result in bugs. It is recommended to leave this on, but if you need to debug a test and don't want to have to deal with the extra passes, you can temporarily set it to false.`val checkRenderIdempotence: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [startFrom](start-from.md) | How to start the workflow – see [StartMode](-start-mode/index.md).`val startFrom: StartMode<StateT>` |
