/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.workflow1.ui.backstack;

import com.squareup.workflow1.ui.WorkflowUiExperimentalApi;
import com.squareup.workflow1.ui.backstack.BackStackScreenKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0005\"\u00028\u0000\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0016\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0017H\u0016J*\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u0000\"\b\b\u0001\u0010\u001b*\u00020\u00022\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001b0\u001dJ?\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u0000\"\b\b\u0001\u0010\u001b*\u00020\u00022'\u0010\u001c\u001a#\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001b0\u001fJ\u001f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000H\u0086\u0002J\b\u0010#\u001a\u00020$H\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lcom/squareup/workflow1/ui/backstack/BackStackScreen;", "StackedT", "", "bottom", "rest", "", "(Ljava/lang/Object;[Ljava/lang/Object;)V", "", "(Ljava/lang/Object;Ljava/util/List;)V", "backStack", "getBackStack", "()Ljava/util/List;", "frames", "getFrames", "top", "getTop", "()Ljava/lang/Object;", "Ljava/lang/Object;", "equals", "", "other", "get", "index", "", "(I)Ljava/lang/Object;", "hashCode", "map", "R", "transform", "Lkotlin/Function1;", "mapIndexed", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "plus", "toString", "", "wf1-container-common"})
@WorkflowUiExperimentalApi
public final class BackStackScreen<StackedT> {
    @NotNull
    private final List<StackedT> frames;
    @NotNull
    private final StackedT top;
    @NotNull
    private final List<StackedT> backStack;

    public BackStackScreen(@NotNull StackedT bottom, @NotNull List<? extends StackedT> rest) {
        Intrinsics.checkNotNullParameter(bottom, (String)"bottom");
        Intrinsics.checkNotNullParameter(rest, (String)"rest");
        this.frames = CollectionsKt.plus((Collection)CollectionsKt.listOf(bottom), (Iterable)rest);
        this.top = CollectionsKt.last(this.frames);
        this.backStack = this.frames.subList(0, this.frames.size() - 1);
    }

    public BackStackScreen(@NotNull StackedT bottom, StackedT ... rest) {
        Intrinsics.checkNotNullParameter(bottom, (String)"bottom");
        Intrinsics.checkNotNullParameter(rest, (String)"rest");
        this(bottom, ArraysKt.toList((Object[])rest));
    }

    @NotNull
    public final List<StackedT> getFrames() {
        return this.frames;
    }

    @NotNull
    public final StackedT getTop() {
        return this.top;
    }

    @NotNull
    public final List<StackedT> getBackStack() {
        return this.backStack;
    }

    @NotNull
    public final StackedT get(int index) {
        return this.frames.get(index);
    }

    @NotNull
    public final BackStackScreen<StackedT> plus(@Nullable BackStackScreen<StackedT> other) {
        return other == null ? this : new BackStackScreen<StackedT>(this.frames.get(0), CollectionsKt.plus((Collection)this.frames.subList(1, this.frames.size()), (Iterable)other.frames));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <R> BackStackScreen<R> map(@NotNull Function1<? super StackedT, ? extends R> transform) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Iterable $this$map$iv = this.frames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(transform.invoke(item$iv$iv));
        }
        return BackStackScreenKt.toBackStackScreen((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <R> BackStackScreen<R> mapIndexed(@NotNull Function2<? super Integer, ? super StackedT, ? extends R> transform) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Iterable $this$mapIndexed$iv = this.frames;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            destination$iv$iv.add(transform.invoke((Object)n, item$iv$iv));
        }
        return BackStackScreenKt.toBackStackScreen((List)destination$iv$iv);
    }

    public boolean equals(@Nullable Object other) {
        BackStackScreen backStackScreen = other instanceof BackStackScreen ? (BackStackScreen)other : null;
        return Intrinsics.areEqual(backStackScreen == null ? null : backStackScreen.frames, this.frames);
    }

    public int hashCode() {
        return ((Object)this.frames).hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.frames + ')';
    }
}

