/*
 * Copyright 2010-2012 Craig S. Dickson (http://craigsdickson.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.squeakysand.osgi.framework;

import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Helps with creating various {@link Filter} objects.
 * 
 * @author <a href="http://craigsdickson.com">Craig S. Dickson</a>
 */
public class FilterBuilder {

    private static final Logger LOG = LoggerFactory.getLogger(FilterBuilder.class);

    public static Filter singleClassFilter(BundleContext context, Class<?> clazz) {
        Filter result = null;
        try {
            result = context.createFilter("(objectClass=" + clazz.getName() + ")");
        } catch (InvalidSyntaxException e) {
            LOG.error(e.getMessage(), e);
        }
        return result;
    }

}
