/*
 * Decompiled with CFR 0.152.
 */
package com.squeakysand.osgi.framework;

import com.squeakysand.commons.util.Predicate;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBundleListener
implements BundleListener {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingBundleListener.class);
    private Logger logger;
    private Predicate<? super BundleEvent> eventFilter;

    public LoggingBundleListener() {
        this(LOG);
    }

    public LoggingBundleListener(Logger logger) {
        this.logger = logger;
        this.setDefaultPredicate();
    }

    public void setEventFilter(Predicate<? super BundleEvent> eventFilter) {
        if (eventFilter == null) {
            this.setDefaultPredicate();
        } else {
            this.eventFilter = eventFilter;
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (this.eventFilter.evaluate((Object)event)) {
            this.logger.info(event.toString());
        }
    }

    private void setDefaultPredicate() {
        this.eventFilter = Predicate.ALWAYS_TRUE;
    }
}

