/*
 * Decompiled with CFR 0.152.
 */
package com.squeakysand.osgi.framework;

import com.squeakysand.commons.util.Predicate;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFrameworkListener
implements FrameworkListener {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingFrameworkListener.class);
    private Logger logger;
    private Predicate<? super FrameworkEvent> eventFilter;

    public LoggingFrameworkListener() {
        this(LOG);
    }

    public LoggingFrameworkListener(Logger logger) {
        this.logger = logger;
        this.setDefaultPredicate();
    }

    public void setEventFilter(Predicate<? super FrameworkEvent> eventFilter) {
        if (eventFilter == null) {
            this.setDefaultPredicate();
        } else {
            this.eventFilter = eventFilter;
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (this.eventFilter.evaluate((Object)event)) {
            this.logger.info(event.toString());
        }
    }

    private void setDefaultPredicate() {
        this.eventFilter = Predicate.ALWAYS_TRUE;
    }
}

