/*
 * Decompiled with CFR 0.152.
 */
package com.squeakysand.osgi.framework;

import com.squeakysand.commons.util.Predicate;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingServiceListener
implements ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingServiceListener.class);
    private Logger logger;
    private Predicate<? super ServiceEvent> eventFilter;

    public LoggingServiceListener() {
        this(LOG);
    }

    public LoggingServiceListener(Logger logger) {
        this.logger = logger;
        this.setDefaultPredicate();
    }

    public void setEventFilter(Predicate<? super ServiceEvent> eventFilter) {
        if (eventFilter == null) {
            this.setDefaultPredicate();
        } else {
            this.eventFilter = eventFilter;
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.eventFilter.evaluate((Object)event)) {
            this.logger.info(event.toString());
        }
    }

    private void setDefaultPredicate() {
        this.eventFilter = Predicate.ALWAYS_TRUE;
    }
}

